/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.internal.Intrinsics;
import okio.Segment;

public final class SegmentPool {
    public static final SegmentPool INSTANCE;
    private static final int MAX_SIZE;
    private static final Segment LOCK;
    private static final int HASH_BUCKET_COUNT;
    private static final AtomicReference[] hashBuckets;

    private SegmentPool() {
    }

    public static final Segment take() {
        Segment segment;
        AtomicReference atomicReference = INSTANCE.firstRef();
        Segment segment2 = atomicReference.getAndSet(segment = LOCK);
        if (segment2 == segment) {
            return new Segment();
        }
        if (segment2 == null) {
            atomicReference.set(null);
            return new Segment();
        }
        atomicReference.set(segment2.next);
        segment2.next = null;
        segment2.limit = 0;
        return segment2;
    }

    public static final void recycle(Segment segment) {
        Segment segment2 = segment;
        Intrinsics.checkNotNullParameter(segment2, "segment");
        if (segment2.next == null && segment.prev == null) {
            if (segment.shared) {
                return;
            }
            AtomicReference atomicReference = INSTANCE.firstRef();
            Segment segment3 = (Segment)atomicReference.get();
            if (segment3 == LOCK) {
                return;
            }
            int n = segment3 != null ? segment3.limit : 0;
            if (n >= MAX_SIZE) {
                return;
            }
            Segment segment4 = segment;
            segment4.next = segment3;
            segment4.pos = 0;
            segment.limit = n + 8192;
            if (!atomicReference.compareAndSet(segment3, segment)) {
                segment.next = null;
            }
            return;
        }
        throw new IllegalArgumentException("Failed requirement.".toString());
    }

    private final AtomicReference firstRef() {
        return hashBuckets[(int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L)];
    }

    static {
        int n;
        INSTANCE = new SegmentPool();
        MAX_SIZE = 65536;
        LOCK = new Segment(new byte[0], 0, 0, false, false);
        HASH_BUCKET_COUNT = n = Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 2 - 1);
        AtomicReference[] atomicReferenceArray = new AtomicReference[n];
        for (int i = 0; i < n; ++i) {
            AtomicReference atomicReference;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            atomicReferenceArray[i] = atomicReference2;
        }
        hashBuckets = atomicReferenceArray;
    }
}

