/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.android.DeferredSocketAdapter$Factory;
import okhttp3.internal.platform.android.SocketAdapter;

public final class DeferredSocketAdapter
implements SocketAdapter {
    private final DeferredSocketAdapter$Factory socketAdapterFactory;
    private SocketAdapter delegate;

    public DeferredSocketAdapter(DeferredSocketAdapter$Factory deferredSocketAdapter$Factory) {
        Intrinsics.checkNotNullParameter(deferredSocketAdapter$Factory, "socketAdapterFactory");
        this.socketAdapterFactory = deferredSocketAdapter$Factory;
    }

    private final synchronized SocketAdapter getDelegate(SSLSocket sSLSocket) {
        if (this.delegate == null && this.socketAdapterFactory.matchesSocket(sSLSocket)) {
            this.delegate = this.socketAdapterFactory.create(sSLSocket);
        }
        return this.delegate;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean matchesSocket(SSLSocket sSLSocket) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        return this.socketAdapterFactory.matchesSocket(sSLSocket);
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List list) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(list, "protocols");
        SocketAdapter socketAdapter = ((DeferredSocketAdapter)socketAdapter).getDelegate(sSLSocket);
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sSLSocket, string, list);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        SocketAdapter socketAdapter = ((DeferredSocketAdapter)socketAdapter).getDelegate(sSLSocket);
        return socketAdapter == null ? null : socketAdapter.getSelectedProtocol(sSLSocket);
    }
}

