/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response$Builder;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpHeaders;

public final class Response
implements Closeable {
    private final Request request;
    private final Protocol protocol;
    private final String message;
    private final int code;
    private final Handshake handshake;
    private final Headers headers;
    private final ResponseBody body;
    private final Response networkResponse;
    private final Response cacheResponse;
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final Exchange exchange;
    private CacheControl lazyCacheControl;

    public Response(Request request, Protocol protocol, String string, int n, Handshake handshake2, Headers headers, ResponseBody responseBody, Response response, Response response2, Response response3, long l, long l2, Exchange exchange) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        Intrinsics.checkNotNullParameter(string, "message");
        Intrinsics.checkNotNullParameter(headers, "headers");
        this.request = request;
        this.protocol = protocol;
        this.message = string;
        this.code = n;
        this.handshake = handshake2;
        this.headers = headers;
        this.body = responseBody;
        this.networkResponse = response;
        this.cacheResponse = response2;
        this.priorResponse = response3;
        this.sentRequestAtMillis = l;
        this.receivedResponseAtMillis = l2;
        this.exchange = exchange;
    }

    public static /* synthetic */ String header$default(Response response, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return response.header(string, string2);
    }

    public final Request request() {
        return this.request;
    }

    public final Protocol protocol() {
        return this.protocol;
    }

    public final String message() {
        return this.message;
    }

    public final int code() {
        return this.code;
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final ResponseBody body() {
        return this.body;
    }

    public final Response networkResponse() {
        return this.networkResponse;
    }

    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    public final Response priorResponse() {
        return this.priorResponse;
    }

    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public final Exchange exchange() {
        return this.exchange;
    }

    public final boolean isSuccessful() {
        int n = this.code;
        return 200 <= n && n < 300;
    }

    public final String header(String string, String object) {
        Intrinsics.checkNotNullParameter(string, "name");
        String string2 = ((Response)((Object)string2)).headers.get(string);
        if (string2 != null) {
            object = string2;
        }
        return object;
    }

    public final Response$Builder newBuilder() {
        return new Response$Builder(this);
    }

    public final List challenges() {
        String string;
        Response response = headers;
        Headers headers = response.headers;
        int n = response.code;
        if (n != 401) {
            if (n != 407) {
                return CollectionsKt.emptyList();
            }
            string = "Proxy-Authenticate";
        } else {
            string = "WWW-Authenticate";
        }
        return HttpHeaders.parseChallenges(headers, string);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.lazyCacheControl;
        if (cacheControl == null) {
            this.lazyCacheControl = cacheControl = CacheControl.Companion.parse(this.headers);
        }
        return cacheControl;
    }

    @Override
    public void close() {
        Closeable closeable = ((Response)closeable).body;
        if (closeable != null) {
            ((ResponseBody)closeable).close();
            return;
        }
        throw new IllegalStateException("response is not eligible for a body and must not be closed".toString());
    }

    public String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }
}

