/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;

public final class Cookie$Companion {
    private Cookie$Companion() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean domainMatch(String string, String string2) {
        if (Intrinsics.areEqual(string, string2)) {
            return true;
        }
        if (!StringsKt.endsWith$default(string, string2, false, 2, null)) return false;
        String string3 = string;
        if (string3.charAt(string3.length() - string2.length() - 1) != '.') return false;
        if (Util.canParseAsIpAddress(string)) return false;
        return true;
    }

    private final long parseExpires(String string, int n, int n2) {
        n = this.dateCharacterOffset(string, n, n2, false);
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        Matcher matcher = Cookie.access$getTIME_PATTERN$cp().matcher(string);
        while (n < n2) {
            int n9 = this.dateCharacterOffset(string, n + 1, n2, true);
            matcher.region(n, n9);
            if (n3 == -1 && matcher.usePattern(Cookie.access$getTIME_PATTERN$cp()).matches()) {
                Matcher matcher2 = matcher;
                String string2 = matcher2.group(1);
                Intrinsics.checkNotNullExpressionValue(string2, "matcher.group(1)");
                n = Integer.parseInt(string2);
                String string3 = matcher2.group(2);
                Intrinsics.checkNotNullExpressionValue(string3, "matcher.group(2)");
                n3 = Integer.parseInt(string3);
                String string4 = matcher2.group(3);
                Intrinsics.checkNotNullExpressionValue(string4, "matcher.group(3)");
                n5 = n4 = Integer.parseInt(string4);
                n4 = n3;
                n3 = n;
            } else if (n6 == -1 && matcher.usePattern(Cookie.access$getDAY_OF_MONTH_PATTERN$cp()).matches()) {
                String string5 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue(string5, "matcher.group(1)");
                n6 = n = Integer.parseInt(string5);
            } else if (n7 == -1 && matcher.usePattern(Cookie.access$getMONTH_PATTERN$cp()).matches()) {
                String string6 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue(string6, "matcher.group(1)");
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                String string7 = string6.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string7, "this as java.lang.String).toLowerCase(locale)");
                String string8 = Cookie.access$getMONTH_PATTERN$cp().pattern();
                Intrinsics.checkNotNullExpressionValue(string8, "MONTH_PATTERN.pattern()");
                n7 = n = StringsKt.indexOf$default((CharSequence)string8, string7, 0, false, 6, null) / 4;
            } else if (n8 == -1 && matcher.usePattern(Cookie.access$getYEAR_PATTERN$cp()).matches()) {
                String string9 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue(string9, "matcher.group(1)");
                n8 = n = Integer.parseInt(string9);
            }
            n = this.dateCharacterOffset(string, n9 + 1, n2, false);
        }
        if (70 <= n8 && n8 < 100) {
            n8 += 1900;
        }
        if (n8 >= 0 && n8 < 70) {
            n8 += 2000;
        }
        if (n8 >= 1601) {
            if (n7 != -1) {
                if (1 <= n6 && n6 < 32) {
                    if (n3 >= 0 && n3 < 24) {
                        if (n4 >= 0 && n4 < 60) {
                            if (n5 >= 0 && n5 < 60) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
                                gregorianCalendar.setLenient(false);
                                gregorianCalendar.set(1, n8);
                                gregorianCalendar.set(2, n7 - 1);
                                gregorianCalendar.set(5, n6);
                                gregorianCalendar.set(11, n3);
                                gregorianCalendar.set(12, n4);
                                gregorianCalendar.set(13, n5);
                                gregorianCalendar.set(14, 0);
                                return gregorianCalendar.getTimeInMillis();
                            }
                            throw new IllegalArgumentException("Failed requirement.".toString());
                        }
                        throw new IllegalArgumentException("Failed requirement.".toString());
                    }
                    throw new IllegalArgumentException("Failed requirement.".toString());
                }
                throw new IllegalArgumentException("Failed requirement.".toString());
            }
            throw new IllegalArgumentException("Failed requirement.".toString());
        }
        throw new IllegalArgumentException("Failed requirement.".toString());
    }

    private final int dateCharacterOffset(String string, int n, int n2, boolean bl) {
        while (n < n2) {
            int n3 = n + 1;
            char c = string.charAt(n);
            c = !(c < ' ' && c != '\t' || c >= '\u007f' || c <= '9' && '0' <= c || c <= 'z' && 'a' <= c || c <= 'Z' && 'A' <= c || c == ':') ? (char)'\u0000' : '\u0001';
            if (c == (bl ^ '\u0001')) {
                return n;
            }
            n = n3;
        }
        return n2;
    }

    private final long parseMaxAge(String string) {
        try {
            long l = Long.parseLong(string);
            if (l <= 0L) {
                l = Long.MIN_VALUE;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            if (new Regex("-?\\d+").matches(string)) {
                return StringsKt.startsWith$default(string, "-", false, 2, null) ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private final String parseDomain(String string) {
        if (StringsKt.endsWith$default(string, ".", false, 2, null) ^ true) {
            String string2 = HostnamesKt.toCanonicalHost(StringsKt.removePrefix(string, "."));
            if (string2 != null) {
                return string2;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException("Failed requirement.".toString());
    }

    public /* synthetic */ Cookie$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    public final Cookie parse(HttpUrl httpUrl, String string) {
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        Intrinsics.checkNotNullParameter(string, "setCookie");
        return this.parse$okhttp(System.currentTimeMillis(), httpUrl, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Cookie parse$okhttp(long l, HttpUrl httpUrl, String string) {
        int n;
        String string2 = string;
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        Intrinsics.checkNotNullParameter(string2, "setCookie");
        int n2 = Util.delimiterOffset$default(string2, ';', 0, 0, 6, null);
        int n3 = Util.delimiterOffset$default(string2, '=', 0, n2, 2, null);
        if (n3 == n2) {
            return null;
        }
        String string3 = Util.trimSubstring$default(string, 0, n3, 1, null);
        if (string3.length() == 0) return null;
        if (Util.indexOfControlOrNonAscii(string3) != -1) {
            return null;
        }
        String string4 = Util.trimSubstring(string, n3 + 1, n2);
        if (Util.indexOfControlOrNonAscii(string4) != -1) {
            return null;
        }
        long l2 = 253402300799999L;
        long l3 = -1L;
        String string5 = null;
        Object object = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        ++n2;
        int n4 = string.length();
        while (n2 < n4) {
            int n5;
            block26: {
                String string6;
                String string7;
                block28: {
                    block27: {
                        boolean bl5;
                        block25: {
                            String string8 = string;
                            n5 = Util.delimiterOffset(string8, ';', n2, n4);
                            int n6 = Util.delimiterOffset(string8, '=', n2, n5);
                            string7 = Util.trimSubstring(string, n2, n6);
                            string6 = n6 < n5 ? Util.trimSubstring(string, n6 + 1, n5) : "";
                            if (StringsKt.equals(string7, "expires", true)) {
                                int n7 = 0;
                                int n8 = string6.length();
                                l2 = super.parseExpires(string6, n7, n8);
                                break block25;
                            }
                            if (!StringsKt.equals(string7, "max-age", true)) break block27;
                            try {
                                l3 = super.parseMaxAge(string6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                break block26;
                            }
                        }
                        bl4 = bl5 = true;
                        break block26;
                    }
                    if (!StringsKt.equals(string7, "domain", true)) break block28;
                    try {
                        boolean bl6;
                        string7 = super.parseDomain(string6);
                        bl3 = bl6 = false;
                        string5 = string7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break block26;
                }
                if (StringsKt.equals(string7, "path", true)) {
                    object = string6;
                } else if (StringsKt.equals(string7, "secure", true)) {
                    boolean bl7;
                    bl = bl7 = true;
                } else if (StringsKt.equals(string7, "httponly", true)) {
                    boolean bl8;
                    bl2 = bl8 = true;
                }
            }
            n2 = n5 + 1;
        }
        if (l3 == Long.MIN_VALUE) {
            l2 = Long.MIN_VALUE;
        } else if (l3 != -1L) {
            l2 = l3 <= 9223372036854775L ? l3 * (long)1000 : Long.MAX_VALUE;
            if ((l2 = l + l2) < l || l2 > 253402300799999L) {
                l2 = 253402300799999L;
            }
        }
        String string9 = httpUrl.host();
        if (string5 == null) {
            string5 = string9;
        } else if (!((Cookie$Companion)object2).domainMatch(string9, string5)) {
            return null;
        }
        if (string9.length() != string5.length() && PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(string5) == null) {
            return null;
        }
        if (object != null) {
            if (StringsKt.startsWith$default(object, "/", false, 2, null)) return new Cookie(string3, string4, l2, string5, (String)object, bl, bl2, bl4, bl3, null);
        }
        if ((n = StringsKt.lastIndexOf$default((CharSequence)(object2 = httpUrl.encodedPath()), '/', 0, false, 6, null)) != 0) {
            Object object2 = ((String)object2).substring(0, n);
            Intrinsics.checkNotNullExpressionValue(object2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            object = object2;
            return new Cookie(string3, string4, l2, string5, (String)object, bl, bl2, bl4, bl3, null);
        }
        object = object2 = "/";
        return new Cookie(string3, string4, l2, string5, (String)object, bl, bl2, bl4, bl3, null);
    }

    public final List parseAll(HttpUrl httpUrl, Headers iterable) {
        List list;
        Headers headers = iterable;
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        Intrinsics.checkNotNullParameter(headers, "headers");
        iterable = headers.values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n = 0;
        int n2 = iterable.size();
        while (n < n2) {
            Cookie cookie;
            if ((cookie = ((Cookie$Companion)((Object)list)).parse(httpUrl, (String)iterable.get(n++))) == null) continue;
            if (arrayList == null) {
                ArrayList<Cookie> arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        if (arrayList != null) {
            list = Collections.unmodifiableList(arrayList);
            Intrinsics.checkNotNullExpressionValue(list, "{\n        Collections.un\u2026ableList(cookies)\n      }");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

