/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function10;
import kotlin.jvm.functions.Function11;
import kotlin.jvm.functions.Function12;
import kotlin.jvm.functions.Function13;
import kotlin.jvm.functions.Function14;
import kotlin.jvm.functions.Function15;
import kotlin.jvm.functions.Function16;
import kotlin.jvm.functions.Function17;
import kotlin.jvm.functions.Function18;
import kotlin.jvm.functions.Function19;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function20;
import kotlin.jvm.functions.Function21;
import kotlin.jvm.functions.Function22;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt$parameterizedTypeArguments$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt$parameterizedTypeArguments$2;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

public abstract class ReflectClassUtilKt {
    private static final List PRIMITIVE_CLASSES;
    private static final Map WRAPPER_TO_PRIMITIVE;
    private static final Map PRIMITIVE_TO_WRAPPER;
    private static final Map FUNCTION_CLASSES;

    public static final ClassLoader getSafeClassLoader(Class object) {
        Class clazz = object;
        Intrinsics.checkNotNullParameter(clazz, "<this>");
        object = clazz.getClassLoader();
        if (object == null) {
            object = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue(object, "getSystemClassLoader()");
        }
        return object;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(Class clazz) {
        Intrinsics.checkNotNullParameter(clazz, "<this>");
        return Enum.class.isAssignableFrom(clazz);
    }

    public static final Class getPrimitiveByWrapper(Class clazz) {
        Intrinsics.checkNotNullParameter(clazz, "<this>");
        return (Class)WRAPPER_TO_PRIMITIVE.get(clazz);
    }

    public static final Class getWrapperByPrimitive(Class clazz) {
        Intrinsics.checkNotNullParameter(clazz, "<this>");
        return (Class)PRIMITIVE_TO_WRAPPER.get(clazz);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final ClassId getClassId(Class object) {
        ClassId classId;
        FqName fqName2;
        Class<?> clazz;
        Object object2 = object;
        Intrinsics.checkNotNullParameter(object2, "<this>");
        if (((Class)object2).isPrimitive()) throw new IllegalArgumentException("Can't compute ClassId for primitive type: " + object);
        if (((Class)object).isArray()) throw new IllegalArgumentException("Can't compute ClassId for array type: " + object);
        if (((Class)object).getEnclosingMethod() == null && ((Class)object).getEnclosingConstructor() == null) {
            String string = ((Class)object).getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "simpleName");
            if (!(string.length() == 0)) {
                clazz = ((Class)object).getDeclaringClass();
                if (clazz == null || (clazz = ReflectClassUtilKt.getClassId(clazz)) == null || (clazz = ((ClassId)((Object)clazz)).createNestedClassId(Name.identifier(((Class)object).getSimpleName()))) == null) {
                    clazz = ClassId.topLevel(new FqName(((Class)object).getName()));
                }
                Intrinsics.checkNotNullExpressionValue(clazz, "declaringClass?.classId?\u2026Id.topLevel(FqName(name))");
                return clazz;
            }
        }
        clazz = fqName2;
        fqName2 = new FqName(((Class)object).getName());
        object = classId;
        classId = new ClassId(((FqName)((Object)clazz)).parent(), FqName.topLevel(((FqName)((Object)clazz)).shortName()), true);
        return object;
    }

    public static final String getDesc(Class clazz) {
        String string;
        block14: {
            block13: {
                Class clazz2 = clazz;
                Intrinsics.checkNotNullParameter(clazz2, "<this>");
                if (!clazz2.isPrimitive()) break block13;
                String string2 = clazz.getName();
                switch (string2.hashCode()) {
                    default: {
                        break;
                    }
                    case 109413500: {
                        if (!string2.equals("short")) break;
                        string = "S";
                        break block14;
                    }
                    case 97526364: {
                        if (!string2.equals("float")) break;
                        string = "F";
                        break block14;
                    }
                    case 64711720: {
                        if (!string2.equals("boolean")) break;
                        string = "Z";
                        break block14;
                    }
                    case 3625364: {
                        if (!string2.equals("void")) break;
                        string = "V";
                        break block14;
                    }
                    case 3327612: {
                        if (!string2.equals("long")) break;
                        string = "J";
                        break block14;
                    }
                    case 3052374: {
                        if (!string2.equals("char")) break;
                        string = "C";
                        break block14;
                    }
                    case 3039496: {
                        if (!string2.equals("byte")) break;
                        string = "B";
                        break block14;
                    }
                    case 104431: {
                        if (!string2.equals("int")) break;
                        string = "I";
                        break block14;
                    }
                    case -1325958191: {
                        if (!string2.equals("double")) break;
                        string = "D";
                        break block14;
                    }
                }
                throw new IllegalArgumentException("Unsupported primitive type: " + clazz);
            }
            if (clazz.isArray()) {
                String string3 = clazz.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "name");
                string = StringsKt.replace$default(string3, '.', '/', false, 4, null);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append('L');
                String string4 = clazz.getName();
                Intrinsics.checkNotNullExpressionValue(string4, "name");
                string = stringBuilder.append(StringsKt.replace$default(string4, '.', '/', false, 4, null)).append(';').toString();
            }
        }
        return string;
    }

    public static final List getParameterizedTypeArguments(Type type2) {
        Type type3 = type2;
        Intrinsics.checkNotNullParameter(type3, "<this>");
        if (!(type3 instanceof ParameterizedType)) {
            return CollectionsKt.emptyList();
        }
        ParameterizedType parameterizedType = (ParameterizedType)type2;
        if (parameterizedType.getOwnerType() == null) {
            Object[] objectArray = parameterizedType.getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue(objectArray, "actualTypeArguments");
            return ArraysKt.toList(objectArray);
        }
        return SequencesKt.toList(SequencesKt.flatMap(SequencesKt.generateSequence(type2, ReflectClassUtilKt$parameterizedTypeArguments$1.INSTANCE), ReflectClassUtilKt$parameterizedTypeArguments$2.INSTANCE));
    }

    static {
        ArrayList<Pair> arrayList;
        ArrayList<Pair> arrayList2;
        Object object;
        ArrayList<Pair> arrayList3;
        Object object2 = CollectionsKt.listOf(Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE));
        PRIMITIVE_CLASSES = object2;
        ArrayList<Pair> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<Pair>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (KClass)object2.next();
            arrayList4.add(TuplesKt.to(JvmClassMappingKt.getJavaObjectType((KClass)object), JvmClassMappingKt.getJavaPrimitiveType((KClass)object)));
        }
        WRAPPER_TO_PRIMITIVE = MapsKt.toMap(arrayList4);
        object2 = PRIMITIVE_CLASSES;
        arrayList4 = arrayList2;
        arrayList2 = new ArrayList<Pair>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object = (KClass)object2.next();
            arrayList4.add(TuplesKt.to(JvmClassMappingKt.getJavaPrimitiveType((KClass)object), JvmClassMappingKt.getJavaObjectType((KClass)object)));
        }
        PRIMITIVE_TO_WRAPPER = MapsKt.toMap(arrayList4);
        object2 = CollectionsKt.listOf(Function0.class, Function1.class, Function2.class, Function3.class, Function4.class, Function5.class, Function6.class, Function7.class, Function8.class, Function9.class, Function10.class, Function11.class, Function12.class, Function13.class, Function14.class, Function15.class, Function16.class, Function17.class, Function18.class, Function19.class, Function20.class, Function21.class, Function22.class);
        arrayList4 = arrayList;
        arrayList = new ArrayList<Pair>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
        int n = 0;
        object = object2.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            arrayList4.add(TuplesKt.to((Class)e, n));
            n = n2;
        }
        FUNCTION_CLASSES = MapsKt.toMap(arrayList4);
    }
}

