/*
 * Decompiled with CFR 0.152.
 */
package kotlin.ranges;

import kotlin.collections.CharIterator;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.CharProgression$Companion;
import kotlin.ranges.CharProgressionIterator;

public abstract class CharProgression
implements Iterable,
KMappedMarker {
    public static final CharProgression$Companion Companion = new CharProgression$Companion(null);
    private final char first;
    private final char last;
    private final int step;

    public CharProgression(char c, char c2, int n) {
        if (n != 0) {
            if (n != Integer.MIN_VALUE) {
                this.first = c;
                this.last = (char)ProgressionUtilKt.getProgressionLastElement(c, c2, n);
                this.step = n;
                return;
            }
            throw new IllegalArgumentException("Step must be greater than Int.MIN_VALUE to avoid overflow on negation.");
        }
        throw new IllegalArgumentException("Step must be non-zero.");
    }

    public final char getFirst() {
        return this.first;
    }

    public final char getLast() {
        return this.last;
    }

    public CharIterator iterator() {
        CharProgression charProgression = this;
        char c = charProgression.first;
        char c2 = charProgression.last;
        int n = charProgression.step;
        return new CharProgressionIterator(c, c2, n);
    }
}

