/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion;
import okio.GzipSource;
import okio.Okio;

public final class PublicSuffixDatabase {
    public static final PublicSuffixDatabase$Companion Companion = new PublicSuffixDatabase$Companion(null);
    private static final byte[] WILDCARD_LABEL = new byte[]{42};
    private static final List PREVAILING_RULE = CollectionsKt.listOf((Object)"*");
    private static final PublicSuffixDatabase instance = new PublicSuffixDatabase();
    private final AtomicBoolean listRead;
    private final CountDownLatch readCompleteLatch;
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;

    public PublicSuffixDatabase() {
        CountDownLatch countDownLatch;
        AtomicBoolean atomicBoolean;
        Object object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.listRead = object;
        object = countDownLatch;
        countDownLatch = new CountDownLatch(1);
        v1.readCompleteLatch = object;
    }

    private final List splitDomain(String string) {
        List list = StringsKt.split$default((CharSequence)string, new char[]{'.'}, false, 0, 6, null);
        if (Intrinsics.areEqual(CollectionsKt.last(list), "")) {
            return CollectionsKt.dropLast(list, 1);
        }
        return list;
    }

    private final List findMatchingRule(List object) {
        if (!((PublicSuffixDatabase)object2).listRead.get() && ((PublicSuffixDatabase)object2).listRead.compareAndSet(false, true)) {
            ((PublicSuffixDatabase)object2).readTheListUninterruptibly();
        } else {
            try {
                ((PublicSuffixDatabase)object2).readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (((PublicSuffixDatabase)object2).publicSuffixListBytes != null) {
            Object object2;
            Object object3;
            int n;
            int n2 = object.size();
            byte[][] byArrayArray = new byte[n2][];
            for (n = 0; n < n2; ++n) {
                String string = (String)object.get(n);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                byArrayArray[n] = byArray;
            }
            object = null;
            n = 0;
            while (n < n2) {
                String string;
                int n3 = n + 1;
                PublicSuffixDatabase$Companion publicSuffixDatabase$Companion = Companion;
                byte[] byArray = ((PublicSuffixDatabase)object2).publicSuffixListBytes;
                if (((PublicSuffixDatabase)object2).publicSuffixListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("publicSuffixListBytes");
                    byArray = null;
                }
                if ((string = PublicSuffixDatabase$Companion.access$binarySearch(publicSuffixDatabase$Companion, byArray, byArrayArray, n)) != null) {
                    object = string;
                    break;
                }
                n = n3;
            }
            String string = null;
            if (n2 > 1) {
                byte[][] byArray = (byte[][])byArrayArray.clone();
                int n4 = 0;
                int n5 = byArray.length - 1;
                while (n4 < n5) {
                    String string2;
                    int n6 = n4 + 1;
                    byArray[n4] = WILDCARD_LABEL;
                    object3 = Companion;
                    byte[] byArray2 = ((PublicSuffixDatabase)object2).publicSuffixListBytes;
                    if (((PublicSuffixDatabase)object2).publicSuffixListBytes == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("publicSuffixListBytes");
                        byArray2 = null;
                    }
                    if ((string2 = PublicSuffixDatabase$Companion.access$binarySearch((PublicSuffixDatabase$Companion)object3, byArray2, byArray, n4)) != null) {
                        string = string2;
                        break;
                    }
                    n4 = n6;
                }
            }
            String string3 = null;
            if (string != null) {
                int n7 = n2;
                n2 = 0;
                int n8 = n7 - 1;
                while (n2 < n8) {
                    String string4;
                    int n9 = n2 + 1;
                    PublicSuffixDatabase$Companion publicSuffixDatabase$Companion = Companion;
                    object3 = ((PublicSuffixDatabase)object2).publicSuffixExceptionListBytes;
                    if (((PublicSuffixDatabase)object2).publicSuffixExceptionListBytes == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("publicSuffixExceptionListBytes");
                        object3 = null;
                    }
                    if ((string4 = PublicSuffixDatabase$Companion.access$binarySearch(publicSuffixDatabase$Companion, object3, byArrayArray, n2)) != null) {
                        string3 = string4;
                        break;
                    }
                    n2 = n9;
                }
            }
            if (string3 != null) {
                return StringsKt.split$default((CharSequence)Intrinsics.stringPlus("!", string3), new char[]{'.'}, false, 0, 6, null);
            }
            if (object == null && string == null) {
                return PREVAILING_RULE;
            }
            if (object == null) {
                object2 = null;
            } else {
                char[] cArray = new char[1];
                object2 = cArray;
                cArray[0] = 46;
                object2 = StringsKt.split$default((CharSequence)object, (char[])object2, false, 0, 6, null);
            }
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            if (string == null) {
                object = null;
            } else {
                char[] cArray = new char[1];
                object = cArray;
                cArray[0] = 46;
                object = StringsKt.split$default(string, (char[])object, false, 0, 6, null);
            }
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
            if (object2.size() <= object.size()) {
                object2 = object;
            }
            return object2;
        }
        throw new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.".toString());
    }

    /*
     * Exception decompiling
     */
    private final void readTheListUninterruptibly() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 22->31)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void readTheList() {
        long l;
        Closeable closeable = PublicSuffixDatabase.class.getResourceAsStream("publicsuffixes.gz");
        if (closeable == null) {
            return;
        }
        PublicSuffixDatabase publicSuffixDatabase = this;
        closeable = Okio.buffer(new GzipSource(Okio.source(closeable)));
        Throwable throwable = null;
        try {
            l = closeable.readInt();
        }
        catch (Throwable throwable2) {
            try {
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally(closeable, throwable2);
                throw throwable3;
            }
        }
        byte[] byArray = closeable.readByteArray(l);
        long l2 = closeable.readInt();
        byte[] byArray2 = closeable.readByteArray(l2);
        byte[] byArray3 = byArray2;
        byte[] byArray4 = byArray2;
        PublicSuffixDatabase publicSuffixDatabase2 = this;
        byte[] byArray5 = byArray;
        byte[] byArray6 = byArray;
        PublicSuffixDatabase publicSuffixDatabase3 = this;
        Closeable closeable2 = closeable;
        Throwable throwable4 = throwable;
        CloseableKt.closeFinally(closeable2, throwable4);
        synchronized (publicSuffixDatabase3) {
            Intrinsics.checkNotNull(byArray5);
            publicSuffixDatabase2.publicSuffixListBytes = byArray6;
            Intrinsics.checkNotNull(byArray3);
            publicSuffixDatabase.publicSuffixExceptionListBytes = byArray4;
            publicSuffixDatabase.readCompleteLatch.countDown();
            return;
        }
    }

    public static final /* synthetic */ PublicSuffixDatabase access$getInstance$cp() {
        return instance;
    }

    public final String getEffectiveTldPlusOne(String string) {
        PublicSuffixDatabase publicSuffixDatabase = this;
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "domain");
        String string3 = IDN.toUnicode(string2);
        Intrinsics.checkNotNullExpressionValue(string3, "unicodeDomain");
        List list = publicSuffixDatabase.splitDomain(string3);
        List list2 = publicSuffixDatabase.findMatchingRule(list);
        if (list.size() == list2.size() && ((String)list2.get(0)).charAt(0) != '!') {
            return null;
        }
        int n = ((String)list2.get(0)).charAt(0) == '!' ? list.size() - list2.size() : list.size() - (list2.size() + 1);
        return SequencesKt.joinToString$default(SequencesKt.drop(CollectionsKt.asSequence(this.splitDomain(string)), n), ".", null, null, 0, null, null, 62, null);
    }
}

