/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.Handshake$Companion;
import okhttp3.Handshake$peerCertificates$2;
import okhttp3.TlsVersion;

public final class Handshake {
    public static final Handshake$Companion Companion = new Handshake$Companion(null);
    private final TlsVersion tlsVersion;
    private final CipherSuite cipherSuite;
    private final List localCertificates;
    private final Lazy peerCertificates$delegate;

    public Handshake(TlsVersion tlsVersion, CipherSuite cipherSuite, List list, Function0 function0) {
        Handshake handshake2 = this;
        Intrinsics.checkNotNullParameter((Object)tlsVersion, "tlsVersion");
        Intrinsics.checkNotNullParameter(cipherSuite, "cipherSuite");
        Intrinsics.checkNotNullParameter(list, "localCertificates");
        Intrinsics.checkNotNullParameter(function0, "peerCertificatesFn");
        this.tlsVersion = tlsVersion;
        this.cipherSuite = cipherSuite;
        handshake2.localCertificates = list;
        handshake2.peerCertificates$delegate = LazyKt.lazy(new Handshake$peerCertificates$2(function0));
    }

    private final String getName(Certificate certificate) {
        Object object;
        if (certificate instanceof X509Certificate) {
            object = ((Object)((X509Certificate)certificate).getSubjectDN()).toString();
        } else {
            object = certificate.getType();
            Intrinsics.checkNotNullExpressionValue(object, "type");
        }
        return object;
    }

    public final TlsVersion tlsVersion() {
        return this.tlsVersion;
    }

    public final CipherSuite cipherSuite() {
        return this.cipherSuite;
    }

    public final List localCertificates() {
        return this.localCertificates;
    }

    public final List peerCertificates() {
        return (List)this.peerCertificates$delegate.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Handshake)) return false;
        object = (Handshake)object;
        if (((Handshake)object).tlsVersion != this.tlsVersion) return false;
        if (!Intrinsics.areEqual(((Handshake)object).cipherSuite, this.cipherSuite)) return false;
        if (!Intrinsics.areEqual(((Handshake)object).peerCertificates(), this.peerCertificates())) return false;
        if (!Intrinsics.areEqual(((Handshake)object).localCertificates, this.localCertificates)) return false;
        return true;
    }

    public int hashCode() {
        return (((527 + this.tlsVersion.hashCode()) * 31 + this.cipherSuite.hashCode()) * 31 + ((Object)this.peerCertificates()).hashCode()) * 31 + ((Object)this.localCertificates).hashCode();
    }

    public String toString() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        Object object = this.peerCertificates();
        Object object2 = arrayList2;
        arrayList2 = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            object2.add(this.getName((Certificate)object.next()));
        }
        object = new StringBuilder().append("Handshake{tlsVersion=").append((Object)this.tlsVersion).append(" cipherSuite=").append(this.cipherSuite).append(" peerCertificates=").append(object2.toString()).append(" localCertificates=");
        object2 = this.localCertificates;
        ArrayList<String> arrayList3 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object2, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            arrayList3.add(this.getName((Certificate)object2.next()));
        }
        return ((StringBuilder)object).append(arrayList3).append('}').toString();
    }
}

