/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewCapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.model.CaptureStatus;

public abstract class SpecialTypesKt {
    public static final AbbreviatedType getAbbreviatedType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        kotlinType = kotlinType2.unwrap();
        return kotlinType instanceof AbbreviatedType ? (AbbreviatedType)kotlinType : null;
    }

    public static final SimpleType getAbbreviation(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        kotlinType = SpecialTypesKt.getAbbreviatedType(kotlinType2);
        return kotlinType != null ? ((AbbreviatedType)kotlinType).getAbbreviation() : null;
    }

    public static final SimpleType withAbbreviation(SimpleType simpleType2, SimpleType simpleType3) {
        Intrinsics.checkNotNullParameter(simpleType2, "<this>");
        Intrinsics.checkNotNullParameter(simpleType3, "abbreviatedType");
        if (KotlinTypeKt.isError(simpleType2)) {
            return simpleType2;
        }
        return new AbbreviatedType(simpleType2, simpleType3);
    }

    public static final boolean isDefinitelyNotNullType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return kotlinType2.unwrap() instanceof DefinitelyNotNullType;
    }

    public static final SimpleType makeSimpleTypeDefinitelyNotNullOrNotNull(SimpleType simpleType2, boolean bl) {
        Intrinsics.checkNotNullParameter(simpleType2, "<this>");
        SimpleType simpleType3 = DefinitelyNotNullType.Companion.makeDefinitelyNotNull(simpleType2, bl);
        if (simpleType3 == null && (simpleType3 = SpecialTypesKt.makeIntersectionTypeDefinitelyNotNullOrNotNull(simpleType2)) == null) {
            simpleType3 = simpleType2.makeNullableAsSpecified(false);
        }
        return simpleType3;
    }

    public static /* synthetic */ SimpleType makeSimpleTypeDefinitelyNotNullOrNotNull$default(SimpleType simpleType2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialTypesKt.makeSimpleTypeDefinitelyNotNullOrNotNull(simpleType2, bl);
    }

    public static final NewCapturedType withNotNullProjection(NewCapturedType object) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        NewCapturedType newCapturedType = object;
        object = newCapturedType.getCaptureStatus();
        NewCapturedTypeConstructor newCapturedTypeConstructor = newCapturedType.getConstructor();
        UnwrappedType unwrappedType = newCapturedType.getLowerType();
        TypeAttributes typeAttributes = newCapturedType.getAttributes();
        boolean bl = newCapturedType.isMarkedNullable();
        return new NewCapturedType((CaptureStatus)((Object)object), newCapturedTypeConstructor, unwrappedType, typeAttributes, bl, true);
    }

    public static final UnwrappedType makeDefinitelyNotNullOrNotNull(UnwrappedType unwrappedType, boolean bl) {
        Intrinsics.checkNotNullParameter(unwrappedType, "<this>");
        UnwrappedType unwrappedType2 = DefinitelyNotNullType.Companion.makeDefinitelyNotNull(unwrappedType, bl);
        if (unwrappedType2 == null && (unwrappedType2 = SpecialTypesKt.makeIntersectionTypeDefinitelyNotNullOrNotNull(unwrappedType)) == null) {
            unwrappedType2 = unwrappedType.makeNullableAsSpecified(false);
        }
        return unwrappedType2;
    }

    public static /* synthetic */ UnwrappedType makeDefinitelyNotNullOrNotNull$default(UnwrappedType unwrappedType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return SpecialTypesKt.makeDefinitelyNotNullOrNotNull(unwrappedType, bl);
    }

    private static final SimpleType makeIntersectionTypeDefinitelyNotNullOrNotNull(KotlinType object) {
        if ((object = (object = ((KotlinType)object).getConstructor()) instanceof IntersectionTypeConstructor ? (IntersectionTypeConstructor)object : null) == null) {
            return null;
        }
        if ((object = SpecialTypesKt.makeDefinitelyNotNullOrNotNull((IntersectionTypeConstructor)object)) == null) {
            return null;
        }
        return ((IntersectionTypeConstructor)object).createType();
    }

    private static final IntersectionTypeConstructor makeDefinitelyNotNullOrNotNull(IntersectionTypeConstructor object) {
        IntersectionTypeConstructor intersectionTypeConstructor;
        ArrayList<KotlinType> arrayList;
        boolean bl = false;
        Object object2 = ((IntersectionTypeConstructor)object).getSupertypes();
        ArrayList<KotlinType> arrayList2 = arrayList;
        arrayList = new ArrayList<KotlinType>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            KotlinType kotlinType = (KotlinType)object2.next();
            if (TypeUtils.isNullableType(kotlinType)) {
                bl = true;
                kotlinType = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(kotlinType.unwrap(), false, 1, null);
            }
            arrayList2.add(kotlinType);
        }
        if (!bl) {
            intersectionTypeConstructor = null;
        } else {
            if ((object = ((IntersectionTypeConstructor)object).getAlternativeType()) != null) {
                if (TypeUtils.isNullableType((KotlinType)object)) {
                    object = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(((KotlinType)object).unwrap(), false, 1, null);
                }
            } else {
                object = null;
            }
            intersectionTypeConstructor = new IntersectionTypeConstructor(arrayList2).setAlternative((KotlinType)object);
        }
        return intersectionTypeConstructor;
    }
}

