/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Class;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Constructor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Function;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Package;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Property;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Type;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$ValueParameter;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags$BooleanFlagField;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf$JvmFieldSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf$JvmMethodSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf$JvmPropertySignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf$StringTableTypes;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BitEncoding;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmFlags;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature$Field;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature$Method;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$ExtendableMessage;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$GeneratedExtension;

public final class JvmProtoBufUtil {
    public static final JvmProtoBufUtil INSTANCE = new JvmProtoBufUtil();
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;

    private JvmProtoBufUtil() {
    }

    public static final Pair readClassDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter(stringArray, "data");
        Intrinsics.checkNotNullParameter(stringArray2, "strings");
        byte[] byArray = BitEncoding.decodeBytes(stringArray);
        Intrinsics.checkNotNullExpressionValue(byArray, "decodeBytes(data)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, stringArray2);
    }

    public static final Pair readClassDataFrom(byte[] object, String[] stringArray) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkNotNullParameter(object, "bytes");
        Intrinsics.checkNotNullParameter(stringArray, "strings");
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = INSTANCE.readNameResolver(byteArrayInputStream2, stringArray);
        return new Pair(object, ProtoBuf$Class.parseFrom(byteArrayInputStream2, EXTENSION_REGISTRY));
    }

    public static final Pair readPackageDataFrom(String[] stringArray, String[] stringArray2) {
        Intrinsics.checkNotNullParameter(stringArray, "data");
        Intrinsics.checkNotNullParameter(stringArray2, "strings");
        byte[] byArray = BitEncoding.decodeBytes(stringArray);
        Intrinsics.checkNotNullExpressionValue(byArray, "decodeBytes(data)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, stringArray2);
    }

    public static final Pair readPackageDataFrom(byte[] object, String[] stringArray) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkNotNullParameter(object, "bytes");
        Intrinsics.checkNotNullParameter(stringArray, "strings");
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = INSTANCE.readNameResolver(byteArrayInputStream2, stringArray);
        return new Pair(object, ProtoBuf$Package.parseFrom(byteArrayInputStream2, EXTENSION_REGISTRY));
    }

    public static final Pair readFunctionDataFrom(String[] object, String[] stringArray) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkNotNullParameter(object, "data");
        Intrinsics.checkNotNullParameter(stringArray, "strings");
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(BitEncoding.decodeBytes(object));
        object = INSTANCE.readNameResolver(byteArrayInputStream2, stringArray);
        return new Pair(object, ProtoBuf$Function.parseFrom(byteArrayInputStream2, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(InputStream inputStream2, String[] stringArray) {
        JvmProtoBuf$StringTableTypes jvmProtoBuf$StringTableTypes = JvmProtoBuf$StringTableTypes.parseDelimitedFrom(inputStream2, EXTENSION_REGISTRY);
        Intrinsics.checkNotNullExpressionValue(jvmProtoBuf$StringTableTypes, "parseDelimitedFrom(this, EXTENSION_REGISTRY)");
        return new JvmNameResolver(jvmProtoBuf$StringTableTypes, stringArray);
    }

    public static /* synthetic */ JvmMemberSignature$Field getJvmFieldSignature$default(JvmProtoBufUtil jvmProtoBufUtil, ProtoBuf$Property protoBuf$Property, NameResolver nameResolver, TypeTable typeTable, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return jvmProtoBufUtil.getJvmFieldSignature(protoBuf$Property, nameResolver, typeTable, bl);
    }

    private final String mapTypeDefault(ProtoBuf$Type protoBuf$Type, NameResolver nameResolver) {
        return protoBuf$Type.hasClassName() ? ClassMapperLite.mapClass(nameResolver.getQualifiedClassName(protoBuf$Type.getClassName())) : null;
    }

    public static final boolean isMovedFromInterfaceCompanion(ProtoBuf$Property protoBuf$Property) {
        Intrinsics.checkNotNullParameter(protoBuf$Property, "proto");
        Flags$BooleanFlagField flags$BooleanFlagField = JvmFlags.INSTANCE.getIS_MOVED_FROM_INTERFACE_COMPANION();
        Object object = protoBuf$Property.getExtension(JvmProtoBuf.flags);
        Intrinsics.checkNotNullExpressionValue(object, "proto.getExtension(JvmProtoBuf.flags)");
        Boolean bl = flags$BooleanFlagField.get(((Number)object).intValue());
        Intrinsics.checkNotNullExpressionValue(bl, "JvmFlags.IS_MOVED_FROM_I\u2026nsion(JvmProtoBuf.flags))");
        return bl;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        JvmProtoBuf.registerAllExtensions(extensionRegistryLite);
        Intrinsics.checkNotNullExpressionValue(extensionRegistryLite, "newInstance().apply(JvmP\u2026f::registerAllExtensions)");
        EXTENSION_REGISTRY = extensionRegistryLite;
    }

    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    public final JvmMemberSignature$Method getJvmMethodSignature(ProtoBuf$Function protoBuf$Function, NameResolver nameResolver, TypeTable typeTable) {
        Object object;
        Intrinsics.checkNotNullParameter(protoBuf$Function, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        GeneratedMessageLite$GeneratedExtension generatedMessageLite$GeneratedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkNotNullExpressionValue(generatedMessageLite$GeneratedExtension, "methodSignature");
        Iterator iterator2 = (JvmProtoBuf$JvmMethodSignature)ProtoBufUtilKt.getExtensionOrNull(protoBuf$Function, generatedMessageLite$GeneratedExtension);
        int n = iterator2 != null && ((JvmProtoBuf$JvmMethodSignature)((Object)iterator2)).hasName() ? ((JvmProtoBuf$JvmMethodSignature)((Object)iterator2)).getName() : protoBuf$Function.getName();
        if (iterator2 != null && ((JvmProtoBuf$JvmMethodSignature)((Object)iterator2)).hasDesc()) {
            object = nameResolver.getString(((JvmProtoBuf$JvmMethodSignature)((Object)iterator2)).getDesc());
        } else {
            ArrayList arrayList;
            ArrayList<ProtoBuf$Type> arrayList2;
            ProtoBuf$Function protoBuf$Function2 = protoBuf$Function;
            iterator2 = CollectionsKt.listOfNotNull((Object)ProtoTypeTableUtilKt.receiverType(protoBuf$Function2, typeTable));
            Object object2 = protoBuf$Function2.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(object2, "proto.valueParameterList");
            Object object3 = arrayList2;
            arrayList2 = new ArrayList<ProtoBuf$Type>(CollectionsKt.collectionSizeOrDefault((Iterable)object2, 10));
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ProtoBuf$ValueParameter protoBuf$ValueParameter = (ProtoBuf$ValueParameter)object2.next();
                Intrinsics.checkNotNullExpressionValue(protoBuf$ValueParameter, "it");
                object3.add(ProtoTypeTableUtilKt.type(protoBuf$ValueParameter, typeTable));
            }
            iterator2 = CollectionsKt.plus((Collection)((Object)iterator2), object3);
            object2 = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                object3 = INSTANCE.mapTypeDefault((ProtoBuf$Type)iterator2.next(), nameResolver);
                if (object3 == null) {
                    return null;
                }
                object2.add(object3);
            }
            if ((object = super.mapTypeDefault(ProtoTypeTableUtilKt.returnType(protoBuf$Function, typeTable), nameResolver)) == null) {
                return null;
            }
            object = CollectionsKt.joinToString$default((Iterable)object2, "", "(", ")", 0, null, null, 56, null) + (String)object;
        }
        return new JvmMemberSignature$Method(nameResolver.getString(n), (String)object);
    }

    public final JvmMemberSignature$Method getJvmConstructorSignature(ProtoBuf$Constructor serializable, NameResolver nameResolver, TypeTable typeTable) {
        Intrinsics.checkNotNullParameter(serializable, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        GeneratedMessageLite$GeneratedExtension generatedMessageLite$GeneratedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkNotNullExpressionValue(generatedMessageLite$GeneratedExtension, "constructorSignature");
        Object object = (JvmProtoBuf$JvmMethodSignature)ProtoBufUtilKt.getExtensionOrNull((GeneratedMessageLite$ExtendableMessage)serializable, generatedMessageLite$GeneratedExtension);
        String string = object != null && ((JvmProtoBuf$JvmMethodSignature)object).hasName() ? nameResolver.getString(((JvmProtoBuf$JvmMethodSignature)object).getName()) : "<init>";
        if (object != null && ((JvmProtoBuf$JvmMethodSignature)object).hasDesc()) {
            object = nameResolver.getString(((JvmProtoBuf$JvmMethodSignature)object).getDesc());
        } else {
            ArrayList arrayList;
            object = ((ProtoBuf$Constructor)serializable).getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(object, "proto.valueParameterList");
            serializable = arrayList;
            arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (ProtoBuf$ValueParameter)object.next();
                Intrinsics.checkNotNullExpressionValue(object2, "it");
                object2 = INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf$ValueParameter)object2, typeTable), nameResolver);
                if (object2 == null) {
                    return null;
                }
                serializable.add(object2);
            }
            object = CollectionsKt.joinToString$default((Iterable)((Object)serializable), "", "(", ")V", 0, null, null, 56, null);
        }
        return new JvmMemberSignature$Method(string, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public final JvmMemberSignature$Field getJvmFieldSignature(ProtoBuf$Property protoBuf$Property, NameResolver nameResolver, TypeTable typeTable, boolean bl) {
        void var4_7;
        Object object;
        Intrinsics.checkNotNullParameter(protoBuf$Property, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        GeneratedMessageLite$GeneratedExtension generatedMessageLite$GeneratedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkNotNullExpressionValue(generatedMessageLite$GeneratedExtension, "propertySignature");
        GeneratedMessageLite generatedMessageLite = (JvmProtoBuf$JvmPropertySignature)ProtoBufUtilKt.getExtensionOrNull(protoBuf$Property, generatedMessageLite$GeneratedExtension);
        if (generatedMessageLite == null) {
            return null;
        }
        if ((generatedMessageLite = ((JvmProtoBuf$JvmPropertySignature)generatedMessageLite).hasField() ? ((JvmProtoBuf$JvmPropertySignature)generatedMessageLite).getField() : null) == null && bl) {
            return null;
        }
        if (generatedMessageLite != null && ((JvmProtoBuf$JvmFieldSignature)generatedMessageLite).hasName()) {
            int n = ((JvmProtoBuf$JvmFieldSignature)generatedMessageLite).getName();
        } else {
            int n = protoBuf$Property.getName();
        }
        if (generatedMessageLite != null && ((JvmProtoBuf$JvmFieldSignature)generatedMessageLite).hasDesc()) {
            object = nameResolver.getString(((JvmProtoBuf$JvmFieldSignature)generatedMessageLite).getDesc());
        } else if ((object = ((JvmProtoBufUtil)object).mapTypeDefault(ProtoTypeTableUtilKt.returnType(protoBuf$Property, typeTable), nameResolver)) == null) {
            return null;
        }
        return new JvmMemberSignature$Field(nameResolver.getString((int)var4_7), (String)object);
    }
}

