/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArrayAsCollection;
import kotlin.collections.ArraysKt;
import kotlin.collections.ArraysKt___ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.CollectionsKt__CollectionsJVMKt;
import kotlin.collections.EmptyList;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;

abstract class CollectionsKt__CollectionsKt
extends CollectionsKt__CollectionsJVMKt {
    public static final Collection asCollection(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return new ArrayAsCollection(objectArray, false);
    }

    public static List emptyList() {
        return EmptyList.INSTANCE;
    }

    public static List listOf(Object ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "elements");
        return objectArray.length > 0 ? ArraysKt.asList(objectArray) : CollectionsKt.emptyList();
    }

    public static List mutableListOf(Object ... object) {
        Intrinsics.checkNotNullParameter(object, "elements");
        if (((Object[])object).length == 0) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayAsCollection arrayAsCollection;
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            ArrayAsCollection arrayAsCollection2 = arrayAsCollection;
            arrayAsCollection = new ArrayAsCollection((Object[])object, true);
            arrayList = new ArrayList(arrayAsCollection2);
            object = arrayList2;
        }
        return object;
    }

    public static List listOfNotNull(Object object) {
        return object != null ? CollectionsKt.listOf(object) : CollectionsKt.emptyList();
    }

    public static List listOfNotNull(Object ... objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "elements");
        return ArraysKt___ArraysKt.filterNotNull(objectArray);
    }

    public static IntRange getIndices(Collection collection) {
        Intrinsics.checkNotNullParameter(collection, "<this>");
        return new IntRange(0, collection.size() - 1);
    }

    public static int getLastIndex(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        return list2.size() - 1;
    }

    public static List optimizeReadOnlyList(List list) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        int n = list2.size();
        if (n != 0) {
            if (n == 1) {
                list = CollectionsKt.listOf(list.get(0));
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final int binarySearch(List list, Comparable comparable, int n, int n2) {
        List list2 = list;
        Intrinsics.checkNotNullParameter(list2, "<this>");
        CollectionsKt__CollectionsKt.rangeCheck$CollectionsKt__CollectionsKt(list2.size(), n, n2);
        --n2;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            int n4 = ComparisonsKt.compareValues((Comparable)list.get(n3), comparable);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static /* synthetic */ int binarySearch$default(List list, Comparable comparable, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = list.size();
        }
        return CollectionsKt__CollectionsKt.binarySearch(list, comparable, n, n2);
    }

    private static final void rangeCheck$CollectionsKt__CollectionsKt(int n, int n2, int n3) {
        if (n2 <= n3) {
            if (n2 >= 0) {
                if (n3 <= n) {
                    return;
                }
                throw new IndexOutOfBoundsException("toIndex (" + n3 + ") is greater than size (" + n + ").");
            }
            throw new IndexOutOfBoundsException("fromIndex (" + n2 + ") is less than zero.");
        }
        throw new IllegalArgumentException("fromIndex (" + n2 + ") is greater than toIndex (" + n3 + ").");
    }

    public static void throwIndexOverflow() {
        throw new ArithmeticException("Index overflow has happened.");
    }

    public static void throwCountOverflow() {
        throw new ArithmeticException("Count overflow has happened.");
    }
}

