/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.FlexibleHashMap$Entry;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public abstract class FlexibleHashMap
implements Map {
    protected final AbstractEqualityComparator comparator;
    protected LinkedList[] buckets;
    protected int n = 0;
    protected int threshold = 12;
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public FlexibleHashMap(AbstractEqualityComparator abstractEqualityComparator) {
        this(abstractEqualityComparator, 16, 8);
    }

    public FlexibleHashMap(AbstractEqualityComparator abstractEqualityComparator, int n, int n2) {
        if (abstractEqualityComparator == null) {
            abstractEqualityComparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = abstractEqualityComparator;
        this.buckets = FlexibleHashMap.createEntryListArray(n2);
        this.initialBucketCapacity = n2;
    }

    private static LinkedList[] createEntryListArray(int n) {
        return new LinkedList[n];
    }

    protected int getBucket(Object object) {
        return this.comparator.hashCode(object) & this.buckets.length - 1;
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        FlexibleHashMap flexibleHashMap = this;
        int n = flexibleHashMap.getBucket(object);
        Object object2 = flexibleHashMap.buckets[n];
        if (object2 == null) {
            return null;
        }
        object2 = ((AbstractSequentialList)object2).iterator();
        while (object2.hasNext()) {
            FlexibleHashMap$Entry flexibleHashMap$Entry = (FlexibleHashMap$Entry)object2.next();
            if (!this.comparator.equals(flexibleHashMap$Entry.key, object)) continue;
            return flexibleHashMap$Entry.value;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        if (this.n > this.threshold) {
            this.expand();
        }
        FlexibleHashMap flexibleHashMap = this;
        int n = flexibleHashMap.getBucket(object);
        Object object32 = flexibleHashMap.buckets;
        LinkedList linkedList = flexibleHashMap.buckets[n];
        if (linkedList == null) {
            LinkedList linkedList2;
            linkedList = linkedList2;
            linkedList2 = new LinkedList();
            object32[n] = linkedList;
        }
        for (Object object32 : linkedList) {
            if (!this.comparator.equals(object32.key, object)) continue;
            object32.value = object2;
            ++this.n;
            return object32.value;
        }
        linkedList.add(new FlexibleHashMap$Entry(object, object2));
        ++this.n;
        return null;
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>(linkedListArray.size());
        LinkedList[] linkedListArray = linkedListArray.buckets;
        int n = linkedListArray.buckets.length;
        for (int i = 0; i < n; ++i) {
            Object object = linkedListArray[i];
            if (object == null) continue;
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext()) {
                arrayList2.add(((FlexibleHashMap$Entry)object.next()).value);
            }
        }
        return arrayList2;
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int n = MurmurHash.initialize();
        LinkedList[] linkedListArray = this.buckets;
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            FlexibleHashMap$Entry flexibleHashMap$Entry;
            Object object = linkedListArray[i];
            if (object == null) continue;
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext() && (flexibleHashMap$Entry = (FlexibleHashMap$Entry)object.next()) != null) {
                n = MurmurHash.update(n, this.comparator.hashCode(flexibleHashMap$Entry.key));
            }
        }
        return MurmurHash.finish(n, this.size());
    }

    @Override
    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    protected void expand() {
        LinkedList[] linkedListArray = this.buckets;
        this.currentPrime += 4;
        int n = linkedListArray.length * 2;
        this.buckets = FlexibleHashMap.createEntryListArray(n);
        this.threshold = (int)((double)n * 0.75);
        n = this.size();
        int n2 = this.buckets.length;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2 = linkedListArray[i];
            if (object2 == null) continue;
            object2 = ((AbstractSequentialList)object2).iterator();
            while (object2.hasNext() && (object = (FlexibleHashMap$Entry)object2.next()) != null) {
                FlexibleHashMap$Entry flexibleHashMap$Entry = object;
                object = flexibleHashMap$Entry.key;
                this.put(object, flexibleHashMap$Entry.value);
            }
        }
        this.n = n;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        FlexibleHashMap flexibleHashMap = this;
        flexibleHashMap.buckets = FlexibleHashMap.createEntryListArray(16);
        flexibleHashMap.n = 0;
    }

    public String toString() {
        StringBuilder stringBuilder;
        if (((FlexibleHashMap)((Object)stringBuilder2)).size() == 0) {
            return "{}";
        }
        FlexibleHashMap flexibleHashMap = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append('{');
        boolean bl = true;
        LinkedList[] linkedListArray = flexibleHashMap.buckets;
        int n = flexibleHashMap.buckets.length;
        for (int i = 0; i < n; ++i) {
            FlexibleHashMap$Entry flexibleHashMap$Entry;
            Object object = linkedListArray[i];
            if (object == null) continue;
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext() && (flexibleHashMap$Entry = (FlexibleHashMap$Entry)object.next()) != null) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(flexibleHashMap$Entry.toString());
            }
        }
        Object object = stringBuilder2;
        ((StringBuilder)object).append('}');
        return ((StringBuilder)object).toString();
    }
}

