/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;

public final class AndroidLog {
    public static final AndroidLog INSTANCE;
    private static final CopyOnWriteArraySet configuredLoggers;
    private static final Map knownLoggers;

    private AndroidLog() {
    }

    private final String loggerTag(String string) {
        Object object = (String)knownLoggers.get(string);
        if (object == null) {
            object = StringsKt.take(string, 23);
        }
        return object;
    }

    private final void enableLogging(String object, String string) {
        Logger logger = Logger.getLogger((String)object);
        if (configuredLoggers.add(logger)) {
            logger.setUseParentHandlers(false);
            object = Log.isLoggable((String)string, (int)3) ? Level.FINE : (Log.isLoggable((String)string, (int)4) ? Level.INFO : Level.WARNING);
            Logger logger2 = logger;
            logger2.setLevel((Level)object);
            logger2.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    static {
        LinkedHashMap<Object, String> linkedHashMap;
        INSTANCE = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap<Object, String> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Object, String>();
        Object object = OkHttpClient.class.getPackage();
        object = object == null ? null : ((Package)object).getName();
        if (object != null) {
            linkedHashMap2.put(object, "OkHttp");
        }
        LinkedHashMap<Object, String> linkedHashMap3 = linkedHashMap2;
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue(string, "OkHttpClient::class.java.name");
        linkedHashMap3.put(string, "okhttp.OkHttpClient");
        String string2 = Http2.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Http2::class.java.name");
        linkedHashMap3.put(string2, "okhttp.Http2");
        String string3 = TaskRunner.class.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "TaskRunner::class.java.name");
        linkedHashMap3.put(string3, "okhttp.TaskRunner");
        linkedHashMap3.put("okhttp3.mockwebserver.MockWebServer", "okhttp.MockWebServer");
        knownLoggers = MapsKt.toMap(linkedHashMap3);
    }

    public final void androidLog$okhttp(String string, int n, String string2, Throwable throwable) {
        Intrinsics.checkNotNullParameter(string, "loggerName");
        Intrinsics.checkNotNullParameter(string2, "message");
        String string3 = ((AndroidLog)((Object)string3)).loggerTag(string);
        if (Log.isLoggable((String)string3, (int)n)) {
            if (throwable != null) {
                string2 = string2 + '\n' + Log.getStackTraceString((Throwable)throwable);
            }
            int n2 = 0;
            int n3 = string2.length();
            block0: while (n2 < n3) {
                int n4 = StringsKt.indexOf$default((CharSequence)string2, '\n', n2, false, 4, null);
                if (n4 == -1) {
                    n4 = n3;
                }
                while (true) {
                    int n5 = Math.min(n4, n2 + 4000);
                    String string4 = string2.substring(n2, n5);
                    Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Log.println((int)n, (String)string3, (String)string4);
                    if (n5 >= n4) {
                        n2 = n5 + 1;
                        continue block0;
                    }
                    n2 = n5;
                }
            }
        }
    }

    public final void enable() {
        for (Map.Entry entry : knownLoggers.entrySet()) {
            this.enableLogging((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

