/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.BouncyCastlePlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.OpenJSSEPlatform;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidLog;
import okio.Buffer;

public final class Platform$Companion {
    private Platform$Companion() {
    }

    private final boolean isConscryptPreferred() {
        return Intrinsics.areEqual("Conscrypt", Security.getProviders()[0].getName());
    }

    private final boolean isOpenJSSEPreferred() {
        return Intrinsics.areEqual("OpenJSSE", Security.getProviders()[0].getName());
    }

    private final boolean isBouncyCastlePreferred() {
        return Intrinsics.areEqual("BC", Security.getProviders()[0].getName());
    }

    private final Platform findPlatform() {
        return this.isAndroid() ? this.findAndroidPlatform() : this.findJvmPlatform();
    }

    private final Platform findAndroidPlatform() {
        AndroidLog.INSTANCE.enable();
        Object object = Android10Platform.Companion.buildIfSupported();
        if (object == null) {
            object = AndroidPlatform.Companion.buildIfSupported();
            Intrinsics.checkNotNull(object);
        }
        return object;
    }

    private final Platform findJvmPlatform() {
        Platform platform;
        if (((Platform$Companion)object).isConscryptPreferred() && (platform = ConscryptPlatform.Companion.buildIfSupported()) != null) {
            return platform;
        }
        if (((Platform$Companion)object).isBouncyCastlePreferred() && (platform = BouncyCastlePlatform.Companion.buildIfSupported()) != null) {
            return platform;
        }
        if (((Platform$Companion)object).isOpenJSSEPreferred() && (object = OpenJSSEPlatform.Companion.buildIfSupported()) != null) {
            return object;
        }
        Object object = Jdk9Platform.Companion.buildIfSupported();
        if (object != null) {
            return object;
        }
        object = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
        if (object != null) {
            return object;
        }
        return new Platform();
    }

    public /* synthetic */ Platform$Companion(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    public static final /* synthetic */ Platform access$findPlatform(Platform$Companion platform$Companion) {
        return platform$Companion.findPlatform();
    }

    public final Platform get() {
        return Platform.access$getPlatform$cp();
    }

    public final List alpnProtocolNames(List object) {
        ArrayList arrayList;
        ArrayList arrayList2;
        List list = object;
        Intrinsics.checkNotNullParameter(list, "protocols");
        Iterator iterator2 = arrayList2;
        arrayList2 = new ArrayList();
        for (Object e : list) {
            if (!((Protocol)((Object)e) != Protocol.HTTP_1_0)) continue;
            iterator2.add(e);
        }
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            object.add(((Protocol)((Object)iterator2.next())).toString());
        }
        return object;
    }

    public final boolean isAndroid() {
        return Intrinsics.areEqual("Dalvik", System.getProperty("java.vm.name"));
    }

    public final byte[] concatLengthPrefixed(List object) {
        Buffer buffer;
        Platform$Companion platform$Companion = buffer2;
        List list = object;
        Intrinsics.checkNotNullParameter(list, "protocols");
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        object = platform$Companion.alpnProtocolNames(list).iterator();
        while (object.hasNext()) {
            Buffer buffer3 = buffer2;
            String string = (String)object.next();
            buffer3.writeByte(string.length());
            buffer3.writeUtf8(string);
        }
        return buffer2.readByteArray();
    }
}

