/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0;
import okhttp3.CertificatePinner$Builder;
import okhttp3.CertificatePinner$Companion;
import okhttp3.CertificatePinner$check$1;
import okhttp3.internal.tls.CertificateChainCleaner;

public final class CertificatePinner {
    public static final CertificatePinner$Companion Companion = new CertificatePinner$Companion(null);
    public static final CertificatePinner DEFAULT = new CertificatePinner$Builder().build();
    private final Set pins;
    private final CertificateChainCleaner certificateChainCleaner;

    public CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(set, "pins");
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public /* synthetic */ CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certificateChainCleaner = null;
        }
        this(set, certificateChainCleaner);
    }

    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    public final void check(String string, List list) {
        CertificatePinner$check$1 certificatePinner$check$1;
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(list, "peerCertificates");
        CertificatePinner$check$1 certificatePinner$check$12 = certificatePinner$check$1;
        certificatePinner$check$1 = new CertificatePinner$check$1(this, list, string);
        this.check$okhttp(string, certificatePinner$check$12);
    }

    public final void check$okhttp(String string, Function0 object) {
        StringBuilder stringBuilder;
        Object object2;
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(object, "cleanedPeerCertificatesFn");
        Object object3 = ((CertificatePinner)object3).findMatchingPins(string);
        if (object3.isEmpty()) {
            return;
        }
        object = (List)object.invoke();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            X509Certificate cfr_ignored_0 = (X509Certificate)iterator2.next();
            object2 = object3.iterator();
            if (!object2.hasNext()) continue;
            LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0.m(object2.next());
            throw null;
        }
        Object object4 = object;
        object = stringBuilder;
        new StringBuilder().append("Certificate pinning failure!");
        ((StringBuilder)object).append("\n  Peer certificate chain:");
        iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            Object object5 = object;
            object2 = (X509Certificate)iterator2.next();
            ((StringBuilder)object5).append("\n    ");
            ((StringBuilder)object5).append(Companion.pin((Certificate)object2));
            ((StringBuilder)object5).append(": ");
            ((StringBuilder)object5).append(((X509Certificate)object2).getSubjectDN().getName());
        }
        Object object6 = object;
        ((StringBuilder)object6).append("\n  Pinned certificates for ");
        ((StringBuilder)object6).append(string);
        ((StringBuilder)object6).append(":");
        object3 = object3.iterator();
        while (object3.hasNext()) {
            Object object7 = object;
            LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0.m(object3.next());
            ((StringBuilder)object7).append("\n    ");
            ((StringBuilder)object7).append((Object)null);
        }
        object3 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(object3, "StringBuilder().apply(builderAction).toString()");
        throw new SSLPeerUnverifiedException((String)object3);
    }

    public final List findMatchingPins(String object) {
        Intrinsics.checkNotNullParameter(object, "hostname");
        List list = CollectionsKt.emptyList();
        object = ((CertificatePinner)((Object)list)).pins.iterator();
        if (!object.hasNext()) {
            return list;
        }
        LazyJavaPackageScope$classes$1$$ExternalSyntheticThrowCCEIfNotNull0.m(object.next());
        throw null;
    }

    public final CertificatePinner withCertificateChainCleaner$okhttp(CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(certificateChainCleaner, "certificateChainCleaner");
        if (!Intrinsics.areEqual(certificatePinner3.certificateChainCleaner, certificateChainCleaner)) {
            CertificatePinner certificatePinner;
            CertificatePinner certificatePinner2 = certificatePinner;
            certificatePinner = new CertificatePinner(certificatePinner3.pins, certificateChainCleaner);
            CertificatePinner certificatePinner3 = certificatePinner2;
        }
        return certificatePinner3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof CertificatePinner)) return false;
        object = (CertificatePinner)object;
        if (!Intrinsics.areEqual(((CertificatePinner)object).pins, this.pins)) return false;
        if (!Intrinsics.areEqual(((CertificatePinner)object).certificateChainCleaner, this.certificateChainCleaner)) return false;
        return true;
    }

    public int hashCode() {
        CertificatePinner certificatePinner = this;
        int n = (1517 + ((Object)certificatePinner.pins).hashCode()) * 41;
        CertificateChainCleaner certificateChainCleaner = certificatePinner.certificateChainCleaner;
        int n2 = certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0;
        return n + n2;
    }
}

