/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Collection;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.Check$DefaultImpls;

final class NoDefaultAndVarargsCheck
implements Check {
    public static final NoDefaultAndVarargsCheck INSTANCE = new NoDefaultAndVarargsCheck();
    private static final String description = "should not have varargs or parameters with default values";

    private NoDefaultAndVarargsCheck() {
    }

    @Override
    public String getDescription() {
        return description;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean check(FunctionDescriptor callableDescriptor) {
        boolean bl;
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Intrinsics.checkNotNullParameter(callableDescriptor2, "functionDescriptor");
        Iterator iterator2 = callableDescriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(iterator2, "functionDescriptor.valueParameters");
        if (iterator2 instanceof Collection && iterator2.isEmpty()) {
            return true;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            callableDescriptor = (ValueParameterDescriptor)iterator2.next();
            Intrinsics.checkNotNullExpressionValue(callableDescriptor, "it");
            if (DescriptorUtilsKt.declaresOrInheritsDefaultValue((ValueParameterDescriptor)callableDescriptor)) return false;
            if (callableDescriptor.getVarargElementType() != null) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @Override
    public String invoke(FunctionDescriptor functionDescriptor) {
        return Check$DefaultImpls.invoke(this, functionDescriptor);
    }
}

