/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;

public final class ErrorType
extends SimpleType {
    private final TypeConstructor constructor;
    private final MemberScope memberScope;
    private final ErrorTypeKind kind;
    private final List arguments;
    private final boolean isMarkedNullable;
    private final String[] formatParams;
    private final String debugMessage;

    public ErrorType(TypeConstructor typeConstructor2, MemberScope memberScope2, ErrorTypeKind errorTypeKind, List list, boolean bl, String ... stringArray) {
        Intrinsics.checkNotNullParameter(typeConstructor2, "constructor");
        Intrinsics.checkNotNullParameter(memberScope2, "memberScope");
        Intrinsics.checkNotNullParameter((Object)errorTypeKind, "kind");
        Intrinsics.checkNotNullParameter(list, "arguments");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        this.constructor = typeConstructor2;
        this.memberScope = memberScope2;
        this.kind = errorTypeKind;
        this.arguments = list;
        this.isMarkedNullable = bl;
        this.formatParams = stringArray;
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        String string = String.format(errorTypeKind.getDebugMessage(), Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(format, *args)");
        this.debugMessage = string;
    }

    public /* synthetic */ ErrorType(TypeConstructor typeConstructor2, MemberScope memberScope2, ErrorTypeKind errorTypeKind, List list, boolean bl, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(typeConstructor2, memberScope2, errorTypeKind, list, bl, stringArray);
    }

    @Override
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public MemberScope getMemberScope() {
        return this.memberScope;
    }

    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    @Override
    public List getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    public final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    public TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter(typeAttributes, "newAttributes");
        return this;
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        ErrorType errorType = stringArray;
        String[] stringArray = errorType.getConstructor();
        MemberScope memberScope2 = errorType.getMemberScope();
        ErrorTypeKind errorTypeKind = errorType.kind;
        List list = errorType.getArguments();
        stringArray = Arrays.copyOf(errorType.formatParams, errorType.formatParams.length);
        return new ErrorType((TypeConstructor)stringArray, memberScope2, errorTypeKind, list, bl, stringArray);
    }

    @Override
    public ErrorType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }
}

