/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory$createArrayValue$1;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory$createArrayValue$3;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class ConstantValueFactory {
    public static final ConstantValueFactory INSTANCE = new ConstantValueFactory();

    private ConstantValueFactory() {
    }

    private final ArrayValue createArrayValue(List list, PrimitiveType primitiveType) {
        ConstantValueFactory$createArrayValue$3 constantValueFactory$createArrayValue$3;
        ArrayList arrayList;
        List list2 = CollectionsKt.toList(list);
        list = arrayList;
        arrayList = new ArrayList();
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            ConstantValue constantValue = ((ConstantValueFactory)((Object)constantValueFactory$createArrayValue$32)).createConstantValue(iterator2.next());
            if (constantValue == null) continue;
            list.add(constantValue);
        }
        ConstantValueFactory$createArrayValue$3 constantValueFactory$createArrayValue$32 = constantValueFactory$createArrayValue$3;
        constantValueFactory$createArrayValue$3 = new ConstantValueFactory$createArrayValue$3(primitiveType);
        return new ArrayValue(list, constantValueFactory$createArrayValue$32);
    }

    public final ArrayValue createArrayValue(List list, KotlinType kotlinType) {
        ConstantValueFactory$createArrayValue$1 constantValueFactory$createArrayValue$1;
        Intrinsics.checkNotNullParameter(list, "value");
        Intrinsics.checkNotNullParameter(kotlinType, "type");
        ConstantValueFactory$createArrayValue$1 constantValueFactory$createArrayValue$12 = constantValueFactory$createArrayValue$1;
        constantValueFactory$createArrayValue$1 = new ConstantValueFactory$createArrayValue$1(kotlinType);
        return new ArrayValue(list, constantValueFactory$createArrayValue$12);
    }

    public final ConstantValue createConstantValue(Object object) {
        Object object2;
        if (object instanceof Byte) {
            ByteValue byteValue;
            object2 = byteValue;
            byteValue = new ByteValue(((Number)object).byteValue());
        } else if (object instanceof Short) {
            ShortValue shortValue;
            object2 = shortValue;
            shortValue = new ShortValue(((Number)object).shortValue());
        } else if (object instanceof Integer) {
            IntValue intValue;
            object2 = intValue;
            intValue = new IntValue(((Number)object).intValue());
        } else if (object instanceof Long) {
            LongValue longValue;
            object2 = longValue;
            longValue = new LongValue(((Number)object).longValue());
        } else if (object instanceof Character) {
            CharValue charValue;
            object2 = charValue;
            charValue = new CharValue(((Character)object).charValue());
        } else if (object instanceof Float) {
            FloatValue floatValue;
            object2 = floatValue;
            floatValue = new FloatValue(((Number)object).floatValue());
        } else if (object instanceof Double) {
            DoubleValue doubleValue;
            object2 = doubleValue;
            doubleValue = new DoubleValue(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            BooleanValue booleanValue;
            object2 = booleanValue;
            booleanValue = new BooleanValue((Boolean)object);
        } else if (object instanceof String) {
            StringValue stringValue;
            object2 = stringValue;
            stringValue = new StringValue((String)object);
        } else if (object instanceof byte[]) {
            object2 = super.createArrayValue(ArraysKt.toList((byte[])object), PrimitiveType.BYTE);
        } else if (object instanceof short[]) {
            object2 = super.createArrayValue(ArraysKt.toList((short[])object), PrimitiveType.SHORT);
        } else if (object instanceof int[]) {
            object2 = super.createArrayValue(ArraysKt.toList((int[])object), PrimitiveType.INT);
        } else if (object instanceof long[]) {
            object2 = super.createArrayValue(ArraysKt.toList((long[])object), PrimitiveType.LONG);
        } else if (object instanceof char[]) {
            object2 = super.createArrayValue(ArraysKt.toList((char[])object), PrimitiveType.CHAR);
        } else if (object instanceof float[]) {
            object2 = super.createArrayValue(ArraysKt.toList((float[])object), PrimitiveType.FLOAT);
        } else if (object instanceof double[]) {
            object2 = super.createArrayValue(ArraysKt.toList((double[])object), PrimitiveType.DOUBLE);
        } else if (object instanceof boolean[]) {
            object2 = super.createArrayValue(ArraysKt.toList((boolean[])object), PrimitiveType.BOOLEAN);
        } else if (object == null) {
            NullValue nullValue;
            object2 = nullValue;
            nullValue = new NullValue();
        } else {
            object2 = null;
        }
        return object2;
    }
}

