/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;

public abstract class InlineClassesUtilsKt {
    private static final FqName JVM_INLINE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmInline");
    private static final ClassId JVM_INLINE_ANNOTATION_CLASS_ID;

    public static final boolean isInlineClass(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        return declarationDescriptor2 instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final KotlinType unsubstitutedUnderlyingType(KotlinType object) {
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        object = kotlinType.getConstructor().getDeclarationDescriptor();
        if (!(object instanceof ClassDescriptor)) {
            object = null;
        }
        return (object = (ClassDescriptor)object) != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? (SimpleType)((InlineClassRepresentation)object).getUnderlyingType() : null;
    }

    public static final boolean isInlineClassType(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        annotated = kotlinType.getConstructor().getDeclarationDescriptor();
        return annotated != null ? InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)annotated) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGetterOfUnderlyingPropertyOfInlineClass(CallableDescriptor callableDescriptor) {
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Intrinsics.checkNotNullParameter(callableDescriptor2, "<this>");
        if (!(callableDescriptor2 instanceof PropertyGetterDescriptor)) return false;
        PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)callableDescriptor).getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "correspondingProperty");
        if (!InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isUnderlyingPropertyOfInlineClass(VariableDescriptor variableDescriptor) {
        VariableDescriptor variableDescriptor2 = variableDescriptor;
        Intrinsics.checkNotNullParameter(variableDescriptor2, "<this>");
        if (variableDescriptor2.getExtensionReceiverParameter() != null) return false;
        Object object = variableDescriptor.getContainingDeclaration();
        object = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (!Intrinsics.areEqual(object != null && (object = DescriptorUtilsKt.getInlineClassRepresentation((ClassDescriptor)object)) != null ? ((InlineClassRepresentation)object).getUnderlyingPropertyName() : null, variableDescriptor.getName())) return false;
        return true;
    }

    static {
        ClassId classId = ClassId.topLevel(JVM_INLINE_ANNOTATION_FQ_NAME);
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(JVM_INLINE_ANNOTATION_FQ_NAME)");
        JVM_INLINE_ANNOTATION_CLASS_ID = classId;
    }
}

