/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream$OutOfSpaceException;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public final class CodedOutputStream {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private int totalBytesWritten;
    private final OutputStream output;

    public void writeDouble(int n, double d) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 1);
        codedOutputStream.writeDoubleNoTag(d);
    }

    public void writeFloat(int n, float f) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 5);
        codedOutputStream.writeFloatNoTag(f);
    }

    public void writeInt32(int n, int n2) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 0);
        codedOutputStream.writeInt32NoTag(n2);
    }

    public void writeBool(int n, boolean bl) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 0);
        codedOutputStream.writeBoolNoTag(bl);
    }

    public void writeGroup(int n, MessageLite messageLite) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 3);
        codedOutputStream.writeGroupNoTag(messageLite);
        codedOutputStream.writeTag(n, 4);
    }

    public void writeMessage(int n, MessageLite messageLite) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 2);
        codedOutputStream.writeMessageNoTag(messageLite);
    }

    public void writeBytes(int n, ByteString byteString) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 2);
        codedOutputStream.writeBytesNoTag(byteString);
    }

    public void writeUInt32(int n, int n2) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 0);
        codedOutputStream.writeUInt32NoTag(n2);
    }

    public void writeEnum(int n, int n2) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 0);
        codedOutputStream.writeEnumNoTag(n2);
    }

    public void writeSInt64(int n, long l) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(n, 0);
        codedOutputStream.writeSInt64NoTag(l);
    }

    public void writeMessageSetExtension(int n, MessageLite messageLite) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeTag(1, 3);
        codedOutputStream.writeUInt32(2, n);
        codedOutputStream.writeMessage(3, messageLite);
        codedOutputStream.writeTag(1, 4);
    }

    public void writeDoubleNoTag(double d) {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(d));
    }

    public void writeFloatNoTag(float f) {
        this.writeRawLittleEndian32(Float.floatToRawIntBits(f));
    }

    public void writeUInt64NoTag(long l) {
        this.writeRawVarint64(l);
    }

    public void writeInt64NoTag(long l) {
        this.writeRawVarint64(l);
    }

    public void writeInt32NoTag(int n) {
        if (n >= 0) {
            this.writeRawVarint32(n);
        } else {
            this.writeRawVarint64(n);
        }
    }

    public void writeFixed64NoTag(long l) {
        this.writeRawLittleEndian64(l);
    }

    public void writeFixed32NoTag(int n) {
        this.writeRawLittleEndian32(n);
    }

    public void writeBoolNoTag(boolean bl) {
        this.writeRawByte(bl ? 1 : 0);
    }

    public void writeStringNoTag(String string) {
        CodedOutputStream codedOutputStream = object;
        byte[] byArray = string.getBytes("UTF-8");
        Object object = byArray;
        codedOutputStream.writeRawVarint32(byArray.length);
        codedOutputStream.writeRawBytes((byte[])object);
    }

    public void writeGroupNoTag(MessageLite messageLite) {
        messageLite.writeTo(this);
    }

    public void writeMessageNoTag(MessageLite messageLite) {
        CodedOutputStream codedOutputStream = this;
        codedOutputStream.writeRawVarint32(messageLite.getSerializedSize());
        messageLite.writeTo(codedOutputStream);
    }

    public void writeBytesNoTag(ByteString byteString) {
        this.writeRawVarint32(byteString.size());
        this.writeRawBytes(byteString);
    }

    public void writeByteArrayNoTag(byte[] byArray) {
        this.writeRawVarint32(byArray.length);
        this.writeRawBytes(byArray);
    }

    public void writeUInt32NoTag(int n) {
        this.writeRawVarint32(n);
    }

    public void writeEnumNoTag(int n) {
        this.writeInt32NoTag(n);
    }

    public void writeSFixed32NoTag(int n) {
        this.writeRawLittleEndian32(n);
    }

    public void writeSFixed64NoTag(long l) {
        this.writeRawLittleEndian64(l);
    }

    public void writeSInt32NoTag(int n) {
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32(n));
    }

    public void writeSInt64NoTag(long l) {
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64(l));
    }

    public void flush() {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    public void writeRawByte(byte by) {
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        CodedOutputStream codedOutputStream = this;
        int n = this.position;
        this.position = n + 1;
        codedOutputStream.buffer[n] = by;
        ++codedOutputStream.totalBytesWritten;
    }

    public void writeRawByte(int n) {
        this.writeRawByte((byte)n);
    }

    public void writeRawBytes(ByteString byteString) {
        int n = byteString.size();
        this.writeRawBytes(byteString, 0, n);
    }

    public void writeRawBytes(byte[] byArray) {
        int n = byArray.length;
        this.writeRawBytes(byArray, 0, n);
    }

    public void writeRawBytes(byte[] byArray, int n, int n2) {
        int n3 = this.limit;
        int n4 = this.position;
        if (n3 - n4 >= n2) {
            CodedOutputStream codedOutputStream = this;
            System.arraycopy(byArray, n, this.buffer, n4, n2);
            codedOutputStream.position += n2;
            codedOutputStream.totalBytesWritten += n2;
        } else {
            int n5 = n2;
            int n6 = n;
            int n7 = n;
            n = n3 - n4;
            System.arraycopy(byArray, n7, this.buffer, n4, n);
            n2 = n6 + n;
            n3 = n5 - n;
            CodedOutputStream codedOutputStream = this;
            codedOutputStream.position = codedOutputStream.limit;
            codedOutputStream.totalBytesWritten += n;
            codedOutputStream.refreshBuffer();
            if (n3 <= codedOutputStream.limit) {
                System.arraycopy(byArray, n2, this.buffer, 0, n3);
                this.position = n3;
            } else {
                this.output.write(byArray, n2, n3);
            }
            this.totalBytesWritten += n3;
        }
    }

    public void writeRawBytes(ByteString byteString, int n, int n2) {
        int n3 = this.limit;
        int n4 = this.position;
        if (n3 - n4 >= n2) {
            CodedOutputStream codedOutputStream = this;
            byteString.copyTo(this.buffer, n, n4, n2);
            codedOutputStream.position += n2;
            codedOutputStream.totalBytesWritten += n2;
        } else {
            int n5 = n2;
            n2 = n3 - n4;
            byteString.copyTo(this.buffer, n, n4, n2);
            n += n2;
            n3 = n5 - n2;
            CodedOutputStream codedOutputStream = this;
            codedOutputStream.position = codedOutputStream.limit;
            codedOutputStream.totalBytesWritten += n2;
            codedOutputStream.refreshBuffer();
            if (n3 <= codedOutputStream.limit) {
                byteString.copyTo(this.buffer, n, 0, n3);
                this.position = n3;
            } else {
                byteString.writeTo(this.output, n, n3);
            }
            this.totalBytesWritten += n3;
        }
    }

    public void writeTag(int n, int n2) {
        this.writeRawVarint32(WireFormat.makeTag(n, n2));
    }

    public void writeRawVarint32(int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.writeRawByte(n);
                return;
            }
            this.writeRawByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public void writeRawVarint64(long l) {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)l);
                return;
            }
            this.writeRawByte((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public void writeRawLittleEndian32(int n) {
        this.writeRawByte(n & 0xFF);
        this.writeRawByte(n >> 8 & 0xFF);
        this.writeRawByte(n >> 16 & 0xFF);
        this.writeRawByte(n >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long l) {
        this.writeRawByte((int)l & 0xFF);
        this.writeRawByte((int)(l >> 8) & 0xFF);
        this.writeRawByte((int)(l >> 16) & 0xFF);
        this.writeRawByte((int)(l >> 24) & 0xFF);
        this.writeRawByte((int)(l >> 32) & 0xFF);
        this.writeRawByte((int)(l >> 40) & 0xFF);
        this.writeRawByte((int)(l >> 48) & 0xFF);
        this.writeRawByte((int)(l >> 56) & 0xFF);
    }

    static int computePreferredBufferSize(int n) {
        if (n > 4096) {
            return 4096;
        }
        return n;
    }

    private CodedOutputStream(OutputStream outputStream, byte[] byArray) {
        CodedOutputStream codedOutputStream = this;
        this.totalBytesWritten = 0;
        this.output = outputStream;
        codedOutputStream.buffer = byArray;
        codedOutputStream.position = 0;
        this.limit = byArray.length;
    }

    public static CodedOutputStream newInstance(OutputStream outputStream, int n) {
        return new CodedOutputStream(outputStream, new byte[n]);
    }

    public static int computeDoubleSize(int n, double d) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeDoubleSizeNoTag(d);
    }

    public static int computeFloatSize(int n, float f) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeFloatSizeNoTag(f);
    }

    public static int computeInt32Size(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeInt32SizeNoTag(n2);
    }

    public static int computeBoolSize(int n, boolean bl) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBoolSizeNoTag(bl);
    }

    public static int computeMessageSize(int n, MessageLite messageLite) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeMessageSizeNoTag(messageLite);
    }

    public static int computeBytesSize(int n, ByteString byteString) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeBytesSizeNoTag(byteString);
    }

    public static int computeEnumSize(int n, int n2) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeEnumSizeNoTag(n2);
    }

    public static int computeSInt64Size(int n, long l) {
        return CodedOutputStream.computeTagSize(n) + CodedOutputStream.computeSInt64SizeNoTag(l);
    }

    public static int computeDoubleSizeNoTag(double d) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float f) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long l) {
        return CodedOutputStream.computeRawVarint64Size(l);
    }

    public static int computeInt64SizeNoTag(long l) {
        return CodedOutputStream.computeRawVarint64Size(l);
    }

    public static int computeInt32SizeNoTag(int n) {
        if (n >= 0) {
            return CodedOutputStream.computeRawVarint32Size(n);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean bl) {
        return 1;
    }

    public static int computeStringSizeNoTag(String object) {
        byte[] byArray;
        try {
            byArray = ((String)object).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported.", unsupportedEncodingException);
        }
        object = byArray;
        return CodedOutputStream.computeRawVarint32Size(byArray.length) + ((Object)object).length;
    }

    public static int computeGroupSizeNoTag(MessageLite messageLite) {
        return messageLite.getSerializedSize();
    }

    public static int computeMessageSizeNoTag(MessageLite messageLite) {
        int n = messageLite.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(n) + n;
    }

    public static int computeBytesSizeNoTag(ByteString byteString) {
        return CodedOutputStream.computeRawVarint32Size(byteString.size()) + byteString.size();
    }

    public static int computeByteArraySizeNoTag(byte[] byArray) {
        return CodedOutputStream.computeRawVarint32Size(byArray.length) + byArray.length;
    }

    public static int computeUInt32SizeNoTag(int n) {
        return CodedOutputStream.computeRawVarint32Size(n);
    }

    public static int computeEnumSizeNoTag(int n) {
        return CodedOutputStream.computeInt32SizeNoTag(n);
    }

    public static int computeSFixed32SizeNoTag(int n) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long l) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int n) {
        return CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(n));
    }

    public static int computeSInt64SizeNoTag(long l) {
        return CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(l));
    }

    private void refreshBuffer() {
        OutputStream outputStream = ((CodedOutputStream)object).output;
        if (outputStream != null) {
            CodedOutputStream codedOutputStream = object;
            CodedOutputStream codedOutputStream2 = object;
            Object object = codedOutputStream2.buffer;
            int n = codedOutputStream2.position;
            outputStream.write((byte[])object, 0, n);
            codedOutputStream.position = 0;
            return;
        }
        throw new CodedOutputStream$OutOfSpaceException();
    }

    public static int computeTagSize(int n) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(n, 0));
    }

    public static int computeRawVarint32Size(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeRawVarint64Size(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long l) {
        return l << 1 ^ l >> 63;
    }
}

