/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.UtfEncodingKt;

public abstract class BitEncoding {
    private static final boolean FORCE_8TO7_ENCODING;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void addModuloByte(byte[] byArray, int n) {
        if (byArray == null) {
            BitEncoding.$$$reportNull$$$0(4);
        }
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(byArray[i] + n & 0x7F);
        }
    }

    public static byte[] decodeBytes(String[] objectArray) {
        if (objectArray == null) {
            BitEncoding.$$$reportNull$$$0(7);
        }
        if (objectArray.length > 0 && !objectArray[0].isEmpty()) {
            char c = objectArray[0].charAt(0);
            if (c == '\u0000') {
                byte[] byArray = UtfEncodingKt.stringsToBytes(BitEncoding.dropMarker(objectArray));
                objectArray = byArray;
                if (byArray == null) {
                    BitEncoding.$$$reportNull$$$0(8);
                }
                return objectArray;
            }
            if (c == '\uffff') {
                objectArray = BitEncoding.dropMarker(objectArray);
            }
        }
        byte[] byArray = BitEncoding.combineStringArrayIntoBytes(objectArray);
        BitEncoding.addModuloByte(byArray, 127);
        return BitEncoding.decode7to8(byArray);
    }

    private static String[] dropMarker(String[] stringArray) {
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(9);
        }
        String[] stringArray2 = (String[])stringArray.clone();
        stringArray2[0] = stringArray2[0].substring(1);
        return stringArray2;
    }

    private static byte[] combineStringArrayIntoBytes(String[] stringArray) {
        if (stringArray == null) {
            BitEncoding.$$$reportNull$$$0(11);
        }
        int n = 0;
        for (String string : stringArray) {
            if (!$assertionsDisabled && string.length() > 65535) {
                throw new AssertionError((Object)("String is too long: " + string.length()));
            }
            n += string.length();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (String string : stringArray) {
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                byArray[n2++] = (byte)string.charAt(i);
            }
        }
        return byArray;
    }

    private static byte[] decode7to8(byte[] byArray) {
        if (byArray == null) {
            BitEncoding.$$$reportNull$$$0(13);
        }
        int n = byArray.length * 7 / 8;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4 = n3 + 1;
            byArray2[i] = (byte)(((byArray[n2] & 0xFF) >>> n3) + ((byArray[++n2] & (1 << n4) - 1) << 7 - n3));
            if (n3 == 6) {
                ++n2;
                n3 = 0;
                continue;
            }
            n3 = n4;
        }
        return byArray2;
    }

    static {
        String string;
        $assertionsDisabled = BitEncoding.class.desiredAssertionStatus() ^ true;
        try {
            string = System.getProperty("kotlin.jvm.serialization.use8to7");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        FORCE_8TO7_ENCODING = "true".equals(string);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        String string = n != 1 && n != 3 && n != 6 && n != 8 && n != 10 && n != 12 && n != 14 ? "Argument for @NotNull parameter '%s' of %s.%s must not be null" : "@NotNull method %s.%s must not return null";
        Object[] objectArray = new Object[n != 1 && n != 3 && n != 6 && n != 8 && n != 10 && n != 12 && n != 14 ? 3 : 2];
        objectArray[0] = n != 1 && n != 3 && n != 6 && n != 8 && n != 10 && n != 12 && n != 14 ? "data" : "kotlin/reflect/jvm/internal/impl/metadata/jvm/deserialization/BitEncoding";
        objectArray[1] = n != 1 ? (n != 3 ? (n != 6 ? (n != 8 ? (n != 10 ? (n != 12 ? (n != 14 ? "kotlin/reflect/jvm/internal/impl/metadata/jvm/deserialization/BitEncoding" : "decode7to8") : "combineStringArrayIntoBytes") : "dropMarker") : "decodeBytes") : "splitBytesToStringArray") : "encode8to7") : "encodeBytes";
        switch (n) {
            default: {
                objectArray[2] = "encodeBytes";
                break;
            }
            case 13: {
                objectArray[2] = "decode7to8";
                break;
            }
            case 11: {
                objectArray[2] = "combineStringArrayIntoBytes";
                break;
            }
            case 9: {
                objectArray[2] = "dropMarker";
                break;
            }
            case 7: {
                objectArray[2] = "decodeBytes";
                break;
            }
            case 5: {
                objectArray[2] = "splitBytesToStringArray";
                break;
            }
            case 4: {
                objectArray[2] = "addModuloByte";
                break;
            }
            case 2: {
                objectArray[2] = "encode8to7";
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
        }
        string = String.format(string, objectArray);
        if (n != 1 && n != 3 && n != 6 && n != 8 && n != 10 && n != 12 && n != 14) {
            IllegalArgumentException illegalArgumentException;
            runtimeException = illegalArgumentException;
            illegalArgumentException = new IllegalArgumentException(string);
        } else {
            IllegalStateException illegalStateException;
            runtimeException = illegalStateException;
            illegalStateException = new IllegalStateException(string);
        }
        throw runtimeException;
    }
}

