/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Package;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$GeneratedExtension;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.text.StringsKt;

public final class JvmPackagePartSource
implements DeserializedContainerSource {
    private final JvmClassName className;
    private final JvmClassName facadeClassName;
    private final IncompatibleVersionErrorData incompatibility;
    private final boolean isPreReleaseInvisible;
    private final DeserializedContainerAbiStability abiStability;
    private final KotlinJvmBinaryClass knownJvmBinaryClass;
    private final String moduleName;

    public JvmPackagePartSource(JvmClassName object, JvmClassName jvmClassName, ProtoBuf$Package protoBuf$Package, NameResolver nameResolver, IncompatibleVersionErrorData incompatibleVersionErrorData, boolean bl, DeserializedContainerAbiStability deserializedContainerAbiStability, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter(object, "className");
        Intrinsics.checkNotNullParameter(protoBuf$Package, "packageProto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter((Object)deserializedContainerAbiStability, "abiStability");
        this.className = object;
        this.facadeClassName = jvmClassName;
        this.incompatibility = incompatibleVersionErrorData;
        this.isPreReleaseInvisible = bl;
        this.abiStability = deserializedContainerAbiStability;
        this.knownJvmBinaryClass = kotlinJvmBinaryClass;
        GeneratedMessageLite$GeneratedExtension generatedMessageLite$GeneratedExtension = JvmProtoBuf.packageModuleName;
        Intrinsics.checkNotNullExpressionValue(generatedMessageLite$GeneratedExtension, "packageModuleName");
        object = (Integer)ProtoBufUtilKt.getExtensionOrNull(protoBuf$Package, generatedMessageLite$GeneratedExtension);
        if (object == null || (object = nameResolver.getString(((Number)object).intValue())) == null) {
            object = "main";
        }
        this.moduleName = object;
    }

    public JvmPackagePartSource(KotlinJvmBinaryClass kotlinJvmBinaryClass, ProtoBuf$Package protoBuf$Package, NameResolver nameResolver, IncompatibleVersionErrorData incompatibleVersionErrorData, boolean bl, DeserializedContainerAbiStability deserializedContainerAbiStability) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        Intrinsics.checkNotNullParameter(kotlinJvmBinaryClass, "kotlinClass");
        Intrinsics.checkNotNullParameter(protoBuf$Package, "packageProto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter((Object)deserializedContainerAbiStability, "abiStability");
        JvmClassName jvmClassName = JvmClassName.byClassId(kotlinJvmBinaryClass2.getClassId());
        Intrinsics.checkNotNullExpressionValue(jvmClassName, "byClassId(kotlinClass.classId)");
        Object object = kotlinJvmBinaryClass2.getClassHeader().getMultifileClassName();
        object = object != null && object.length() > 0 ? JvmClassName.byInternalName((String)object) : null;
        this(jvmClassName, (JvmClassName)object, protoBuf$Package, nameResolver, incompatibleVersionErrorData, bl, deserializedContainerAbiStability, kotlinJvmBinaryClass);
    }

    public JvmClassName getClassName() {
        return this.className;
    }

    public JvmClassName getFacadeClassName() {
        return this.facadeClassName;
    }

    public final KotlinJvmBinaryClass getKnownJvmBinaryClass() {
        return this.knownJvmBinaryClass;
    }

    @Override
    public String getPresentableString() {
        return "Class '" + this.getClassId().asSingleFqName().asString() + '\'';
    }

    public final Name getSimpleName() {
        String string = this.getClassName().getInternalName();
        Intrinsics.checkNotNullExpressionValue(string, "className.internalName");
        Name name = Name.identifier(StringsKt.substringAfterLast$default(string, '/', null, 2, null));
        Intrinsics.checkNotNullExpressionValue(name, "identifier(className.int\u2026.substringAfterLast('/'))");
        return name;
    }

    public final ClassId getClassId() {
        JvmPackagePartSource jvmPackagePartSource = fqName2;
        FqName fqName2 = jvmPackagePartSource.getClassName().getPackageFqName();
        return new ClassId(fqName2, jvmPackagePartSource.getSimpleName());
    }

    public String toString() {
        return JvmPackagePartSource.class.getSimpleName() + ": " + this.getClassName();
    }

    @Override
    public SourceFile getContainingFile() {
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        Intrinsics.checkNotNullExpressionValue(sourceFile, "NO_SOURCE_FILE");
        return sourceFile;
    }
}

