/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;

public abstract class DescriptorBasedTypeSignatureMappingKt {
    public static final Object mapType(KotlinType object, JvmTypeFactory object2, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter object3, Function3 function3) {
        Intrinsics.checkNotNullParameter(object, "kotlinType");
        Intrinsics.checkNotNullParameter(object2, "factory");
        Intrinsics.checkNotNullParameter(typeMappingMode, "mode");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, "typeMappingConfiguration");
        Intrinsics.checkNotNullParameter(function3, "writeGenericType");
        Object object4 = typeMappingConfiguration.preprocessType((KotlinType)object);
        if (object4 != null) {
            return DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object4, (JvmTypeFactory)object2, typeMappingMode, typeMappingConfiguration, (JvmDescriptorTypeWriter)object3, function3);
        }
        if (FunctionTypesKt.isSuspendFunctionType((KotlinType)object)) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType((KotlinType)object), (JvmTypeFactory)object2, typeMappingMode, typeMappingConfiguration, (JvmDescriptorTypeWriter)object3, function3);
        }
        object4 = SimpleClassicTypeSystemContext.INSTANCE;
        Object object5 = TypeSignatureMappingKt.mapBuiltInType((TypeSystemCommonBackendContext)object4, (KotlinTypeMarker)object, (JvmTypeFactory)object2, typeMappingMode);
        if (object5 != null) {
            object2 = TypeSignatureMappingKt.boxTypeIfNeeded((JvmTypeFactory)object2, object5, typeMappingMode.getNeedPrimitiveBoxing());
            function3.invoke(object, object2, typeMappingMode);
            return object2;
        }
        object5 = ((KotlinType)object).getConstructor();
        if (object5 instanceof IntersectionTypeConstructor) {
            object = (IntersectionTypeConstructor)object5;
            object4 = ((IntersectionTypeConstructor)object).getAlternativeType();
            if (object4 == null) {
                object4 = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)object).getSupertypes());
            }
            return DescriptorBasedTypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)object4), (JvmTypeFactory)object2, typeMappingMode, typeMappingConfiguration, (JvmDescriptorTypeWriter)object3, function3);
        }
        if ((object5 = object5.getDeclarationDescriptor()) != null) {
            if (ErrorUtils.isError((DeclarationDescriptor)object5)) {
                Object object6 = object2.createObjectType("error/NonExistentClass");
                typeMappingConfiguration.processErrorType((KotlinType)object, (ClassDescriptor)object5);
                return object6;
            }
            boolean bl = object5 instanceof ClassDescriptor;
            if (bl && KotlinBuiltIns.isArray((KotlinType)object)) {
                if (((KotlinType)object).getArguments().size() == 1) {
                    object = (TypeProjection)((KotlinType)object).getArguments().get(0);
                    object4 = object.getType();
                    Intrinsics.checkNotNullExpressionValue(object4, "memberProjection.type");
                    if (object.getProjectionKind() == Variance.IN_VARIANCE) {
                        object = object2.createObjectType("java/lang/Object");
                    } else {
                        object = object.getProjectionKind();
                        Intrinsics.checkNotNullExpressionValue(object, "memberProjection.projectionKind");
                        object = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object4, (JvmTypeFactory)object2, typeMappingMode.toGenericArgumentMode((Variance)((Object)object), true), typeMappingConfiguration, (JvmDescriptorTypeWriter)object3, function3);
                    }
                    return object2.createFromString('[' + object2.toString(object));
                }
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            if (bl) {
                if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)object5) && !typeMappingMode.getNeedInlineClassWrapping() && (object4 = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass((TypeSystemCommonBackendContext)object4, (KotlinTypeMarker)object)) != null) {
                    return DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object4, (JvmTypeFactory)object2, typeMappingMode.wrapInlineClassesMode(), typeMappingConfiguration, (JvmDescriptorTypeWriter)object3, function3);
                }
                if (typeMappingMode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)object5)) {
                    object2 = object2.getJavaLangClassType();
                } else {
                    object3 = (ClassDescriptor)object5;
                    object4 = object3.getOriginal();
                    Intrinsics.checkNotNullExpressionValue(object4, "descriptor.original");
                    object4 = typeMappingConfiguration.getPredefinedTypeForClass((ClassDescriptor)object4);
                    if (object4 == null) {
                        if (object3.getKind() == ClassKind.ENUM_ENTRY) {
                            DeclarationDescriptor declarationDescriptor = object3.getContainingDeclaration();
                            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                            object3 = (ClassDescriptor)declarationDescriptor;
                        }
                        ClassDescriptor classDescriptor = object3.getOriginal();
                        Intrinsics.checkNotNullExpressionValue(classDescriptor, "enumClassIfEnumEntry.original");
                        object2 = object2.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration));
                    } else {
                        object2 = object4;
                    }
                }
                function3.invoke(object, object2, typeMappingMode);
                return object2;
            }
            if (object5 instanceof TypeParameterDescriptor) {
                Object object7 = object;
                object = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)object5);
                if (((KotlinType)object7).isMarkedNullable()) {
                    object = TypeUtilsKt.makeNullable((KotlinType)object);
                }
                Object object8 = object;
                object = FunctionsKt.getDO_NOTHING_3();
                return DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object8, (JvmTypeFactory)object2, typeMappingMode, typeMappingConfiguration, null, (Function3)object);
            }
            if (object5 instanceof TypeAliasDescriptor && typeMappingMode.getMapTypeAliases()) {
                return DescriptorBasedTypeSignatureMappingKt.mapType(((TypeAliasDescriptor)object5).getExpandedType(), (JvmTypeFactory)object2, typeMappingMode, typeMappingConfiguration, (JvmDescriptorTypeWriter)object3, function3);
            }
            throw new UnsupportedOperationException("Unknown type " + object);
        }
        throw new UnsupportedOperationException("no descriptor for type constructor of " + object);
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(CallableDescriptor callableDescriptor) {
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Intrinsics.checkNotNullParameter(callableDescriptor2, "descriptor");
        if (callableDescriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = callableDescriptor.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = callableDescriptor.getReturnType();
        Intrinsics.checkNotNull(kotlinType2);
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (callableDescriptor instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    public static final String computeInternalName(ClassDescriptor object, TypeMappingConfiguration typeMappingConfiguration) {
        TypeMappingConfiguration typeMappingConfiguration2 = typeMappingConfiguration;
        Intrinsics.checkNotNullParameter(object, "klass");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration2, "typeMappingConfiguration");
        Object object2 = typeMappingConfiguration2.getPredefinedFullInternalNameForClass((ClassDescriptor)object);
        if (object2 != null) {
            return object2;
        }
        object2 = object.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(object2, "klass.containingDeclaration");
        String string = SpecialNames.safeIdentifier(object.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "safeIdentifier(klass.name).identifier");
        if (object2 instanceof PackageFragmentDescriptor) {
            object = ((PackageFragmentDescriptor)object2).getFqName();
            if (!((FqName)object).isRoot()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = ((FqName)object).asString();
                Intrinsics.checkNotNullExpressionValue(string2, "fqName.asString()");
                string = stringBuilder.append(StringsKt.replace$default(string2, '.', '/', false, 4, null)).append('/').append(string).toString();
            }
            return string;
        }
        ClassDescriptor classDescriptor = object2 instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
        if (classDescriptor != null) {
            object = typeMappingConfiguration.getPredefinedInternalNameForClass(classDescriptor);
            if (object == null) {
                object = DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
            }
            return (String)object + '$' + string;
        }
        throw new IllegalArgumentException("Unexpected container: " + object2 + " for " + object);
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

