/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

public final class JvmBuiltInsSignatures {
    public static final JvmBuiltInsSignatures INSTANCE;
    private static final Set DROP_LIST_METHOD_SIGNATURES;
    private static final Set HIDDEN_METHOD_SIGNATURES;
    private static final Set VISIBLE_METHOD_SIGNATURES;
    private static final Set MUTABLE_METHOD_SIGNATURES;
    private static final Set HIDDEN_CONSTRUCTOR_SIGNATURES;
    private static final Set VISIBLE_CONSTRUCTOR_SIGNATURES;

    private JvmBuiltInsSignatures() {
    }

    private final Set buildPrimitiveValueMethodsSet() {
        LinkedHashSet linkedHashSet;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        for (JvmPrimitiveType jvmPrimitiveType : CollectionsKt.listOf((Object[])new JvmPrimitiveType[]{JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.CHAR})) {
            String string = jvmPrimitiveType.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "it.wrapperFqName.shortName().asString()");
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = jvmPrimitiveType.getJavaKeywordName() + "Value()" + jvmPrimitiveType.getDesc();
            CollectionsKt.addAll(linkedHashSet2, signatureBuildingComponents.inJavaLang(string, stringArray2));
        }
        return linkedHashSet2;
    }

    private final Set buildPrimitiveStringConstructorsSet() {
        LinkedHashSet linkedHashSet;
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        Object object = JvmPrimitiveType.BYTE;
        JvmPrimitiveType[] jvmPrimitiveTypeArray = new JvmPrimitiveType[]{JvmPrimitiveType.BOOLEAN, object, JvmPrimitiveType.DOUBLE, JvmPrimitiveType.FLOAT, object, JvmPrimitiveType.INT, JvmPrimitiveType.LONG, JvmPrimitiveType.SHORT};
        object = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        Iterator iterator2 = CollectionsKt.listOf((Object[])jvmPrimitiveTypeArray).iterator();
        while (iterator2.hasNext()) {
            Object object2 = signatureBuildingComponents;
            String string = ((JvmPrimitiveType)((Object)iterator2.next())).getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "it.wrapperFqName.shortName().asString()");
            String[] stringArray = ((SignatureBuildingComponents)object2).constructors("Ljava/lang/String;");
            CollectionsKt.addAll((Collection)object, ((SignatureBuildingComponents)object2).inJavaLang(string, Arrays.copyOf(stringArray, stringArray.length)));
        }
        return object;
    }

    static {
        String[] stringArray;
        String[] stringArray2 = stringArray;
        INSTANCE = new JvmBuiltInsSignatures();
        SignatureBuildingComponents signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        String[] stringArray3 = stringArray2;
        SignatureBuildingComponents signatureBuildingComponents2 = signatureBuildingComponents;
        String[] stringArray4 = stringArray2;
        String[] stringArray5 = new String[2];
        stringArray2 = stringArray5;
        stringArray5[0] = "toArray()[Ljava/lang/Object;";
        stringArray5[1] = "toArray([Ljava/lang/Object;)[Ljava/lang/Object;";
        DROP_LIST_METHOD_SIGNATURES = SetsKt.plus(signatureBuildingComponents.inJavaUtil("Collection", stringArray2), "java/lang/annotation/Annotation.annotationType()Ljava/lang/Class;");
        String[] stringArray6 = new String[1];
        stringArray2 = stringArray6;
        stringArray6[0] = "sort(Ljava/util/Comparator;)V";
        Set set = SetsKt.plus(super.buildPrimitiveValueMethodsSet(), signatureBuildingComponents.inJavaUtil("List", stringArray2));
        String[] stringArray7 = new String[48];
        stringArray2 = stringArray7;
        stringArray7[0] = "codePointAt(I)I";
        stringArray7[1] = "codePointBefore(I)I";
        stringArray7[2] = "codePointCount(II)I";
        stringArray7[3] = "compareToIgnoreCase(Ljava/lang/String;)I";
        stringArray7[4] = "concat(Ljava/lang/String;)Ljava/lang/String;";
        stringArray7[5] = "contains(Ljava/lang/CharSequence;)Z";
        stringArray7[6] = "contentEquals(Ljava/lang/CharSequence;)Z";
        stringArray7[7] = "contentEquals(Ljava/lang/StringBuffer;)Z";
        stringArray7[8] = "endsWith(Ljava/lang/String;)Z";
        stringArray7[9] = "equalsIgnoreCase(Ljava/lang/String;)Z";
        stringArray7[10] = "getBytes()[B";
        stringArray7[11] = "getBytes(II[BI)V";
        stringArray7[12] = "getBytes(Ljava/lang/String;)[B";
        stringArray7[13] = "getBytes(Ljava/nio/charset/Charset;)[B";
        stringArray7[14] = "getChars(II[CI)V";
        stringArray7[15] = "indexOf(I)I";
        stringArray7[16] = "indexOf(II)I";
        stringArray7[17] = "indexOf(Ljava/lang/String;)I";
        stringArray7[18] = "indexOf(Ljava/lang/String;I)I";
        stringArray7[19] = "intern()Ljava/lang/String;";
        stringArray7[20] = "isEmpty()Z";
        stringArray7[21] = "lastIndexOf(I)I";
        stringArray7[22] = "lastIndexOf(II)I";
        stringArray7[23] = "lastIndexOf(Ljava/lang/String;)I";
        stringArray7[24] = "lastIndexOf(Ljava/lang/String;I)I";
        stringArray7[25] = "matches(Ljava/lang/String;)Z";
        stringArray7[26] = "offsetByCodePoints(II)I";
        stringArray7[27] = "regionMatches(ILjava/lang/String;II)Z";
        stringArray7[28] = "regionMatches(ZILjava/lang/String;II)Z";
        stringArray7[29] = "replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
        stringArray7[30] = "replace(CC)Ljava/lang/String;";
        stringArray7[31] = "replaceFirst(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;";
        stringArray7[32] = "replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;";
        stringArray7[33] = "split(Ljava/lang/String;I)[Ljava/lang/String;";
        stringArray7[34] = "split(Ljava/lang/String;)[Ljava/lang/String;";
        stringArray7[35] = "startsWith(Ljava/lang/String;I)Z";
        stringArray7[36] = "startsWith(Ljava/lang/String;)Z";
        stringArray7[37] = "substring(II)Ljava/lang/String;";
        stringArray7[38] = "substring(I)Ljava/lang/String;";
        stringArray7[39] = "toCharArray()[C";
        stringArray7[40] = "toLowerCase()Ljava/lang/String;";
        stringArray7[41] = "toLowerCase(Ljava/util/Locale;)Ljava/lang/String;";
        stringArray7[42] = "toUpperCase()Ljava/lang/String;";
        stringArray7[43] = "toUpperCase(Ljava/util/Locale;)Ljava/lang/String;";
        stringArray7[44] = "trim()Ljava/lang/String;";
        stringArray7[45] = "isBlank()Z";
        stringArray7[46] = "lines()Ljava/util/stream/Stream;";
        stringArray7[47] = "repeat(I)Ljava/lang/String;";
        Set set2 = SetsKt.plus(set, signatureBuildingComponents.inJavaLang("String", stringArray2));
        String[] stringArray8 = new String[2];
        stringArray2 = stringArray8;
        stringArray8[0] = "isInfinite()Z";
        stringArray8[1] = "isNaN()Z";
        Set set3 = SetsKt.plus(set2, signatureBuildingComponents.inJavaLang("Double", stringArray2));
        String[] stringArray9 = new String[2];
        stringArray2 = stringArray9;
        stringArray9[0] = "isInfinite()Z";
        stringArray9[1] = "isNaN()Z";
        Set set4 = SetsKt.plus(set3, signatureBuildingComponents.inJavaLang("Float", stringArray2));
        String[] stringArray10 = new String[2];
        stringArray2 = stringArray10;
        stringArray10[0] = "getDeclaringClass()Ljava/lang/Class;";
        stringArray10[1] = "finalize()V";
        Set set5 = SetsKt.plus(set4, signatureBuildingComponents.inJavaLang("Enum", stringArray2));
        String[] stringArray11 = new String[1];
        stringArray2 = stringArray11;
        stringArray11[0] = "isEmpty()Z";
        HIDDEN_METHOD_SIGNATURES = SetsKt.plus(set5, signatureBuildingComponents.inJavaLang("CharSequence", stringArray2));
        String[] stringArray12 = new String[2];
        stringArray2 = stringArray12;
        stringArray12[0] = "codePoints()Ljava/util/stream/IntStream;";
        stringArray12[1] = "chars()Ljava/util/stream/IntStream;";
        Set set6 = signatureBuildingComponents2.inJavaLang("CharSequence", stringArray2);
        String[] stringArray13 = new String[1];
        stringArray2 = stringArray13;
        stringArray13[0] = "forEachRemaining(Ljava/util/function/Consumer;)V";
        Set set7 = SetsKt.plus(set6, signatureBuildingComponents.inJavaUtil("Iterator", stringArray2));
        String[] stringArray14 = new String[2];
        stringArray2 = stringArray14;
        stringArray14[0] = "forEach(Ljava/util/function/Consumer;)V";
        stringArray14[1] = "spliterator()Ljava/util/Spliterator;";
        Set set8 = SetsKt.plus(set7, signatureBuildingComponents.inJavaLang("Iterable", stringArray2));
        String[] stringArray15 = new String[10];
        stringArray2 = stringArray15;
        stringArray15[0] = "setStackTrace([Ljava/lang/StackTraceElement;)V";
        stringArray15[1] = "fillInStackTrace()Ljava/lang/Throwable;";
        stringArray15[2] = "getLocalizedMessage()Ljava/lang/String;";
        stringArray15[3] = "printStackTrace()V";
        stringArray15[4] = "printStackTrace(Ljava/io/PrintStream;)V";
        stringArray15[5] = "printStackTrace(Ljava/io/PrintWriter;)V";
        stringArray15[6] = "getStackTrace()[Ljava/lang/StackTraceElement;";
        stringArray15[7] = "initCause(Ljava/lang/Throwable;)Ljava/lang/Throwable;";
        stringArray15[8] = "getSuppressed()[Ljava/lang/Throwable;";
        stringArray15[9] = "addSuppressed(Ljava/lang/Throwable;)V";
        Set set9 = SetsKt.plus(set8, signatureBuildingComponents.inJavaLang("Throwable", stringArray2));
        String[] stringArray16 = new String[4];
        stringArray2 = stringArray16;
        stringArray16[0] = "spliterator()Ljava/util/Spliterator;";
        stringArray16[1] = "parallelStream()Ljava/util/stream/Stream;";
        stringArray16[2] = "stream()Ljava/util/stream/Stream;";
        stringArray16[3] = "removeIf(Ljava/util/function/Predicate;)Z";
        Set set10 = SetsKt.plus(set9, signatureBuildingComponents.inJavaUtil("Collection", stringArray2));
        String[] stringArray17 = new String[1];
        stringArray2 = stringArray17;
        stringArray17[0] = "replaceAll(Ljava/util/function/UnaryOperator;)V";
        Set set11 = SetsKt.plus(set10, signatureBuildingComponents.inJavaUtil("List", stringArray2));
        String[] stringArray18 = new String[10];
        stringArray2 = stringArray18;
        stringArray18[0] = "getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray18[1] = "forEach(Ljava/util/function/BiConsumer;)V";
        stringArray18[2] = "replaceAll(Ljava/util/function/BiFunction;)V";
        stringArray18[3] = "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray18[4] = "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray18[5] = "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray18[6] = "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z";
        stringArray18[7] = "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray18[8] = "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;";
        stringArray18[9] = "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        VISIBLE_METHOD_SIGNATURES = SetsKt.plus(set11, signatureBuildingComponents.inJavaUtil("Map", stringArray2));
        String[] stringArray19 = new String[1];
        stringArray2 = stringArray19;
        stringArray19[0] = "removeIf(Ljava/util/function/Predicate;)Z";
        Set set12 = signatureBuildingComponents2.inJavaUtil("Collection", stringArray2);
        String[] stringArray20 = new String[2];
        stringArray2 = stringArray20;
        stringArray20[0] = "replaceAll(Ljava/util/function/UnaryOperator;)V";
        stringArray20[1] = "sort(Ljava/util/Comparator;)V";
        Set set13 = SetsKt.plus(set12, signatureBuildingComponents.inJavaUtil("List", stringArray2));
        String[] stringArray21 = new String[9];
        stringArray2 = stringArray21;
        stringArray21[0] = "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;";
        stringArray21[1] = "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray21[2] = "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray21[3] = "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;";
        stringArray21[4] = "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray21[5] = "remove(Ljava/lang/Object;Ljava/lang/Object;)Z";
        stringArray21[6] = "replaceAll(Ljava/util/function/BiFunction;)V";
        stringArray21[7] = "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        stringArray21[8] = "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z";
        MUTABLE_METHOD_SIGNATURES = SetsKt.plus(set13, signatureBuildingComponents.inJavaUtil("Map", stringArray2));
        SignatureBuildingComponents signatureBuildingComponents3 = signatureBuildingComponents;
        String[] stringArray22 = signatureBuildingComponents3.constructors("D");
        SignatureBuildingComponents signatureBuildingComponents4 = signatureBuildingComponents;
        String[] stringArray23 = signatureBuildingComponents4.constructors("[C", "[CII", "[III", "[BIILjava/lang/String;", "[BIILjava/nio/charset/Charset;", "[BLjava/lang/String;", "[BLjava/nio/charset/Charset;", "[BII", "[B", "Ljava/lang/StringBuffer;", "Ljava/lang/StringBuilder;");
        HIDDEN_CONSTRUCTOR_SIGNATURES = SetsKt.plus(SetsKt.plus(super.buildPrimitiveStringConstructorsSet(), signatureBuildingComponents3.inJavaLang("Float", Arrays.copyOf(stringArray22, stringArray22.length))), signatureBuildingComponents4.inJavaLang("String", Arrays.copyOf(stringArray23, stringArray23.length)));
        String[] stringArray24 = signatureBuildingComponents.constructors("Ljava/lang/String;Ljava/lang/Throwable;ZZ");
        VISIBLE_CONSTRUCTOR_SIGNATURES = signatureBuildingComponents.inJavaLang("Throwable", Arrays.copyOf(stringArray24, stringArray24.length));
    }

    public final Set getDROP_LIST_METHOD_SIGNATURES() {
        return DROP_LIST_METHOD_SIGNATURES;
    }

    public final Set getHIDDEN_METHOD_SIGNATURES() {
        return HIDDEN_METHOD_SIGNATURES;
    }

    public final Set getVISIBLE_METHOD_SIGNATURES() {
        return VISIBLE_METHOD_SIGNATURES;
    }

    public final Set getMUTABLE_METHOD_SIGNATURES() {
        return MUTABLE_METHOD_SIGNATURES;
    }

    public final Set getHIDDEN_CONSTRUCTOR_SIGNATURES() {
        return HIDDEN_CONSTRUCTOR_SIGNATURES;
    }

    public final Set getVISIBLE_CONSTRUCTOR_SIGNATURES() {
        return VISIBLE_CONSTRUCTOR_SIGNATURES;
    }

    public final boolean isSerializableInJava(FqNameUnsafe fqNameUnsafe) {
        FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
        Intrinsics.checkNotNullParameter(fqNameUnsafe2, "fqName");
        if (((JvmBuiltInsSignatures)((Object)classId)).isArrayOrPrimitiveArray(fqNameUnsafe2)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId == null) {
            return false;
        }
        try {
            return Serializable.class.isAssignableFrom(Class.forName(classId.asSingleFqName().asString()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final boolean isArrayOrPrimitiveArray(FqNameUnsafe fqNameUnsafe) {
        FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
        Intrinsics.checkNotNullParameter(fqNameUnsafe2, "fqName");
        return Intrinsics.areEqual(fqNameUnsafe2, StandardNames$FqNames.array) || StandardNames.isPrimitiveArray(fqNameUnsafe);
    }
}

