/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.List;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames$FqNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public abstract class FunctionTypesKt {
    public static final boolean isFunctionType(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        annotated = kotlinType.getConstructor().getDeclarationDescriptor();
        return (annotated != null ? FunctionTypesKt.getFunctionalClassKind((DeclarationDescriptor)annotated) : null) == FunctionClassKind.Function;
    }

    public static final boolean isSuspendFunctionType(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        annotated = kotlinType.getConstructor().getDeclarationDescriptor();
        return (annotated != null ? FunctionTypesKt.getFunctionalClassKind((DeclarationDescriptor)annotated) : null) == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isBuiltinFunctionalType(KotlinType annotated) {
        KotlinType kotlinType = annotated;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        annotated = kotlinType.getConstructor().getDeclarationDescriptor();
        return annotated != null && FunctionTypesKt.isBuiltinFunctionalClassDescriptor((DeclarationDescriptor)annotated);
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(DeclarationDescriptor object) {
        DeclarationDescriptor declarationDescriptor = object;
        Intrinsics.checkNotNullParameter(declarationDescriptor, "<this>");
        object = FunctionTypesKt.getFunctionalClassKind(declarationDescriptor);
        return object == FunctionClassKind.Function || object == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isBuiltinExtensionFunctionalType(KotlinType kotlinType) {
        KotlinType kotlinType2 = kotlinType;
        Intrinsics.checkNotNullParameter(kotlinType2, "<this>");
        return FunctionTypesKt.isBuiltinFunctionalType(kotlinType2) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(kotlinType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType kotlinType) {
        return kotlinType.getAnnotations().findAnnotation(StandardNames$FqNames.extensionFunctionType) != null;
    }

    public static final FunctionClassKind getFunctionalClassKind(DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        Intrinsics.checkNotNullParameter(declarationDescriptor2, "<this>");
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage(declarationDescriptor)) {
            return null;
        }
        return FunctionTypesKt.getFunctionalClassKind(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor));
    }

    private static final FunctionClassKind getFunctionalClassKind(FqNameUnsafe object) {
        if (((FqNameUnsafe)object).isSafe() && !((FqNameUnsafe)object).isRoot()) {
            String string = ((FqNameUnsafe)object).shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "shortName().asString()");
            object = ((FqNameUnsafe)object).toSafe().parent();
            Intrinsics.checkNotNullExpressionValue(object, "toSafe().parent()");
            return FunctionClassKind.Companion.getFunctionalClassKind(string, (FqName)object);
        }
        return null;
    }

    public static final int contextFunctionTypeParamsCount(KotlinType object) {
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        object = kotlinType.getAnnotations().findAnnotation(StandardNames$FqNames.contextFunctionTypeParams);
        if (object == null) {
            return 0;
        }
        ConstantValue constantValue = (ConstantValue)MapsKt.getValue(object.getAllValueArguments(), StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        Intrinsics.checkNotNull(constantValue, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntValue");
        return ((Number)((IntValue)constantValue).getValue()).intValue();
    }

    public static final KotlinType getReceiverTypeFromFunctionType(KotlinType object) {
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            object = "Not a function type: " + object;
            throw new AssertionError(object);
        }
        if (!FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType((KotlinType)object)) {
            return null;
        }
        KotlinType kotlinType2 = object;
        int n = FunctionTypesKt.contextFunctionTypeParamsCount(kotlinType2);
        return ((TypeProjection)kotlinType2.getArguments().get(n)).getType();
    }

    public static final List getContextReceiverTypesFromFunctionType(KotlinType arrayList) {
        KotlinType kotlinType = arrayList;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        int n = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && n == 0) {
            arrayList = "Not a function type: " + arrayList;
            throw new AssertionError(arrayList);
        }
        n = FunctionTypesKt.contextFunctionTypeParamsCount((KotlinType)((Object)arrayList));
        if (n == 0) {
            arrayList = CollectionsKt.emptyList();
        } else {
            ArrayList<KotlinType> arrayList2;
            arrayList = ((KotlinType)((Object)arrayList)).getArguments().subList(0, n);
            ArrayList<KotlinType> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<KotlinType>(CollectionsKt.collectionSizeOrDefault(arrayList, 10));
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                KotlinType kotlinType2 = ((TypeProjection)arrayList.next()).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "it.type");
                arrayList3.add(kotlinType2);
            }
            arrayList = arrayList3;
        }
        return arrayList;
    }

    public static final KotlinType getReturnTypeFromFunctionType(KotlinType object) {
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            object = "Not a function type: " + object;
            throw new AssertionError(object);
        }
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.last(((KotlinType)object).getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "arguments.last().type");
        return kotlinType2;
    }

    public static final List getValueParameterTypesFromFunctionType(KotlinType object) {
        int n;
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        boolean bl2 = _Assertions.ENABLED;
        if (bl2 && !bl) {
            object = "Not a function type: " + object;
            throw new AssertionError(object);
        }
        KotlinType kotlinType2 = object;
        List list = kotlinType2.getArguments();
        int n2 = FunctionTypesKt.contextFunctionTypeParamsCount(kotlinType2) + FunctionTypesKt.isBuiltinExtensionFunctionalType((KotlinType)object);
        boolean bl3 = n2 <= (n = list.size() - 1);
        if (bl2 && !bl3) {
            object = "Not an exact function type: " + object;
            throw new AssertionError(object);
        }
        return list.subList(n2, n);
    }

    public static final Name extractParameterNameFromFunctionTypeArgument(KotlinType object) {
        KotlinType kotlinType = object;
        Intrinsics.checkNotNullParameter(kotlinType, "<this>");
        object = kotlinType.getAnnotations().findAnnotation(StandardNames$FqNames.parameterName);
        if (object == null) {
            return null;
        }
        object = (object = CollectionsKt.singleOrNull(object.getAllValueArguments().values())) instanceof StringValue ? (StringValue)object : null;
        if (object != null && (object = (String)((ConstantValue)object).getValue()) != null) {
            if (!Name.isValidIdentifier((String)object)) {
                object = null;
            }
            if (object != null) {
                return Name.identifier((String)object);
            }
        }
        return null;
    }

    public static final List getFunctionTypeArgumentProjections(KotlinType object, List iterator2, List object2, List list, KotlinType kotlinType, KotlinBuiltIns kotlinBuiltIns) {
        ArrayList<TypeProjection> arrayList;
        Intrinsics.checkNotNullParameter(iterator2, "contextReceiverTypes");
        Intrinsics.checkNotNullParameter(object2, "parameterTypes");
        Intrinsics.checkNotNullParameter(kotlinType, "returnType");
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        int n = object2.size() + iterator2.size();
        int n2 = object != null ? 1 : 0;
        ArrayList arrayList2 = new ArrayList(n + n2 + 1);
        ArrayList<TypeProjection> arrayList3 = arrayList;
        arrayList = new ArrayList<TypeProjection>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            arrayList3.add(TypeUtilsKt.asTypeProjection((KotlinType)iterator2.next()));
        }
        arrayList2.addAll(arrayList3);
        object = object != null ? TypeUtilsKt.asTypeProjection((KotlinType)object) : null;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(arrayList2, object);
        int n3 = 0;
        iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Name name;
            object2 = iterator2.next();
            int n4 = n3 + 1;
            if (n3 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object2 = (KotlinType)object2;
            if (list == null || (name = (Name)list.get(n3)) == null || name.isSpecial()) {
                name = null;
            }
            if (name != null) {
                BuiltInAnnotationDescriptor builtInAnnotationDescriptor;
                BuiltInAnnotationDescriptor builtInAnnotationDescriptor2 = builtInAnnotationDescriptor;
                Name name2 = Name.identifier("name");
                String string = name.asString();
                Intrinsics.checkNotNullExpressionValue(string, "name.asString()");
                builtInAnnotationDescriptor = new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames$FqNames.parameterName, MapsKt.mapOf(TuplesKt.to(name2, new StringValue(string))));
                object2 = TypeUtilsKt.replaceAnnotations((KotlinType)object2, Annotations.Companion.create(CollectionsKt.plus((Iterable)((KotlinType)object2).getAnnotations(), (Object)builtInAnnotationDescriptor2)));
            }
            arrayList2.add(TypeUtilsKt.asTypeProjection((KotlinType)object2));
            n3 = n4;
        }
        ArrayList arrayList4 = arrayList2;
        arrayList4.add(TypeUtilsKt.asTypeProjection(kotlinType));
        return arrayList4;
    }

    public static final SimpleType createFunctionType(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType annotated, List list, List list2, List list3, KotlinType kotlinType, boolean bl) {
        List list4 = list2;
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(list, "contextReceiverTypes");
        Intrinsics.checkNotNullParameter(list2, "parameterTypes");
        Intrinsics.checkNotNullParameter(kotlinType, "returnType");
        list2 = FunctionTypesKt.getFunctionTypeArgumentProjections(annotated, list, list2, list3, kotlinType, kotlinBuiltIns);
        int n = list4.size() + list.size();
        int n2 = annotated == null ? 0 : 1;
        KotlinType kotlinType2 = annotated;
        annotated = FunctionTypesKt.getFunctionDescriptor(kotlinBuiltIns, n + n2, bl);
        if (kotlinType2 != null) {
            annotations2 = FunctionTypesKt.withExtensionFunctionAnnotation(annotations2, kotlinBuiltIns);
        }
        if (list.isEmpty() ^ true) {
            annotations2 = FunctionTypesKt.withContextReceiversFunctionAnnotation(annotations2, kotlinBuiltIns, list.size());
        }
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations2), (ClassDescriptor)annotated, list2);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list, List list2, List list3, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, list2, list3, kotlinType2, bl);
    }

    public static final Annotations withExtensionFunctionAnnotation(Annotations annotations2, KotlinBuiltIns kotlinBuiltIns) {
        Intrinsics.checkNotNullParameter(annotations2, "<this>");
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        FqName fqName2 = StandardNames$FqNames.extensionFunctionType;
        if (!annotations2.hasAnnotation(fqName2)) {
            annotations2 = Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Object)new BuiltInAnnotationDescriptor(kotlinBuiltIns, fqName2, MapsKt.emptyMap())));
        }
        return annotations2;
    }

    public static final Annotations withContextReceiversFunctionAnnotation(Annotations annotations2, KotlinBuiltIns kotlinBuiltIns, int n) {
        Intrinsics.checkNotNullParameter(annotations2, "<this>");
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        FqName fqName2 = StandardNames$FqNames.contextFunctionTypeParams;
        if (!annotations2.hasAnnotation(fqName2)) {
            annotations2 = Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Object)new BuiltInAnnotationDescriptor(kotlinBuiltIns, fqName2, MapsKt.mapOf(TuplesKt.to(StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME, new IntValue(n))))));
        }
        return annotations2;
    }

    public static final ClassDescriptor getFunctionDescriptor(KotlinBuiltIns kotlinBuiltIns, int n, boolean bl) {
        Intrinsics.checkNotNullParameter(kotlinBuiltIns, "builtIns");
        ClassDescriptor classDescriptor = bl ? kotlinBuiltIns.getSuspendFunction(n) : kotlinBuiltIns.getFunction(n);
        Intrinsics.checkNotNullExpressionValue(classDescriptor, "if (isSuspendFunction) b\u2026tFunction(parameterCount)");
        return classDescriptor;
    }
}

