/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Arrays;
import kotlin.UninitializedPropertyAccessException;

public abstract class Intrinsics {
    public static String stringPlus(String string, Object object) {
        return string + object;
    }

    public static void checkNotNull(Object object) {
        if (object == null) {
            Intrinsics.throwJavaNpe();
        }
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            Intrinsics.throwJavaNpe(string);
        }
    }

    public static void throwJavaNpe() {
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException());
    }

    public static void throwJavaNpe(String string) {
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException(string));
    }

    public static void throwUninitializedProperty(String string) {
        throw (UninitializedPropertyAccessException)Intrinsics.sanitizeStackTrace(new UninitializedPropertyAccessException(string));
    }

    public static void throwUninitializedPropertyAccessException(String string) {
        Intrinsics.throwUninitializedProperty("lateinit property " + string + " has not been initialized");
    }

    public static void checkNotNullExpressionValue(Object object, String string) {
        if (object != null) {
            return;
        }
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException(string + " must not be null"));
    }

    public static void checkNotNullParameter(Object object, String string) {
        if (object == null) {
            Intrinsics.throwParameterIsNullNPE(string);
        }
    }

    private static void throwParameterIsNullNPE(String string) {
        throw (NullPointerException)Intrinsics.sanitizeStackTrace(new NullPointerException(Intrinsics.createParameterIsNullExceptionMessage(string)));
    }

    private static String createParameterIsNullExceptionMessage(String string) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[4];
        String string2 = stackTraceElement.getClassName();
        return "Parameter specified as non-null is null: method " + string2 + "." + stackTraceElement.getMethodName() + ", parameter " + string;
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static boolean areEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static void throwUndefinedForReified() {
        Intrinsics.throwUndefinedForReified("This function has a reified type parameter and thus can only be inlined at compilation time, not called directly.");
    }

    public static void throwUndefinedForReified(String string) {
        throw new UnsupportedOperationException(string);
    }

    public static void reifiedOperationMarker(int n, String string) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void needClassReification() {
        Intrinsics.throwUndefinedForReified();
    }

    private static Throwable sanitizeStackTrace(Throwable throwable) {
        return Intrinsics.sanitizeStackTrace(throwable, Intrinsics.class.getName());
    }

    static Throwable sanitizeStackTrace(Throwable throwable, String string) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stackTraceElementArray[i].getClassName())) continue;
            n2 = i;
        }
        Throwable throwable2 = throwable;
        throwable2.setStackTrace(Arrays.copyOfRange(stackTraceElementArray, n2 + 1, n));
        return throwable2;
    }
}

