/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.builders.ListBuilder$Itr;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.jvm.internal.Intrinsics;

public final class ListBuilder
extends AbstractMutableList
implements RandomAccess,
Serializable {
    private Object[] array;
    private int offset;
    private int length;
    private boolean isReadOnly;
    private final ListBuilder backing;
    private final ListBuilder root;

    public final List build() {
        if (this.backing == null) {
            ListBuilder listBuilder = this;
            listBuilder.checkIsMutable();
            listBuilder.isReadOnly = true;
            return listBuilder;
        }
        throw new IllegalStateException();
    }

    @Override
    public int getSize() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public Object get(int n) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        return this.array[this.offset + n];
    }

    @Override
    public Object set(int n, Object object) {
        ListBuilder listBuilder = this;
        listBuilder.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        Object[] objectArray = listBuilder.array;
        int n2 = this.offset;
        objectArray[n2 + n] = object;
        return listBuilder.array[n2 + n];
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return new ListBuilder$Itr(this, 0);
    }

    @Override
    public ListIterator listIterator() {
        return new ListBuilder$Itr(this, 0);
    }

    @Override
    public ListIterator listIterator(int n) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        return new ListBuilder$Itr(this, n);
    }

    @Override
    public boolean add(Object object) {
        ListBuilder listBuilder = this;
        listBuilder.checkIsMutable();
        listBuilder.addAtInternal(listBuilder.offset + this.length, object);
        return true;
    }

    @Override
    public void add(int n, Object object) {
        ListBuilder listBuilder = this;
        listBuilder.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        listBuilder.addAtInternal(listBuilder.offset + n, object);
    }

    @Override
    public boolean addAll(Collection collection) {
        Intrinsics.checkNotNullParameter(collection, "elements");
        this.checkIsMutable();
        int n = collection.size();
        ListBuilder listBuilder = this;
        listBuilder.addAllInternal(listBuilder.offset + this.length, collection, n);
        return n > 0;
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        Intrinsics.checkNotNullParameter(collection, "elements");
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(n, this.length);
        int n2 = collection.size();
        ListBuilder listBuilder = this;
        listBuilder.addAllInternal(listBuilder.offset + n, collection, n2);
        return n2 > 0;
    }

    @Override
    public void clear() {
        ListBuilder listBuilder = this;
        listBuilder.checkIsMutable();
        int n = listBuilder.offset;
        listBuilder.removeRangeInternal(n, listBuilder.length);
    }

    @Override
    public Object removeAt(int n) {
        ListBuilder listBuilder = this;
        listBuilder.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(n, this.length);
        return listBuilder.removeAtInternal(listBuilder.offset + n);
    }

    @Override
    public boolean remove(Object object) {
        ListBuilder listBuilder = this;
        listBuilder.checkIsMutable();
        int n = listBuilder.indexOf(object);
        if (n >= 0) {
            this.remove(n);
        }
        return n >= 0;
    }

    @Override
    public boolean removeAll(Collection collection) {
        ListBuilder listBuilder = this;
        Intrinsics.checkNotNullParameter(collection, "elements");
        listBuilder.checkIsMutable();
        int n = listBuilder.offset;
        return listBuilder.retainOrRemoveAllInternal(n, listBuilder.length, collection, false) > 0;
    }

    @Override
    public boolean retainAll(Collection collection) {
        ListBuilder listBuilder = this;
        Intrinsics.checkNotNullParameter(collection, "elements");
        listBuilder.checkIsMutable();
        int n = listBuilder.offset;
        return listBuilder.retainOrRemoveAllInternal(n, listBuilder.length, collection, true) > 0;
    }

    @Override
    public List subList(int n, int n2) {
        ListBuilder listBuilder;
        ListBuilder listBuilder2 = this;
        int n3 = n;
        ListBuilder listBuilder3 = this;
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(n, n2, this.length);
        Object[] objectArray = listBuilder3.array;
        n = listBuilder3.offset + n;
        int n4 = n2 - n3;
        boolean bl = listBuilder2.isReadOnly;
        ListBuilder listBuilder4 = listBuilder2.root;
        if (listBuilder4 == null) {
            listBuilder4 = this;
        }
        ListBuilder listBuilder5 = listBuilder;
        listBuilder5(objectArray, n, n4, bl, this, listBuilder4);
        return listBuilder5;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "destination");
        int n = this.length;
        if (objectArray.length < n) {
            int n2 = this.offset;
            int n3 = n2 + n;
            Class<?> clazz = objectArray.getClass();
            Object[] objectArray2 = Arrays.copyOfRange(this.array, n2, n3, clazz);
            Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOfRange(array, offse\u2026h, destination.javaClass)");
            return objectArray2;
        }
        Object[] objectArray3 = this.array;
        Intrinsics.checkNotNull(objectArray3, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.builders.ListBuilder.toArray>");
        int n4 = this.offset;
        int n5 = n4 + this.length;
        ArraysKt.copyInto(this.array, objectArray, 0, n4, n5);
        int n6 = this.length;
        if (objectArray.length > n6) {
            objectArray[n6] = null;
        }
        return objectArray;
    }

    @Override
    public Object[] toArray() {
        int n = this.offset;
        Object[] objectArray = ArraysKt.copyOfRange(this.array, n, n + this.length);
        Intrinsics.checkNotNull(objectArray, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof List && this.contentEquals((List)object);
    }

    @Override
    public int hashCode() {
        ListBuilder listBuilder = this;
        int n = listBuilder.offset;
        return ListBuilderKt.access$subarrayContentHashCode(this.array, n, listBuilder.length);
    }

    @Override
    public String toString() {
        ListBuilder listBuilder = this;
        int n = listBuilder.offset;
        return ListBuilderKt.access$subarrayContentToString(this.array, n, listBuilder.length);
    }

    private ListBuilder(Object[] objectArray, int n, int n2, boolean bl, ListBuilder listBuilder, ListBuilder listBuilder2) {
        this.array = objectArray;
        this.offset = n;
        this.length = n2;
        this.isReadOnly = bl;
        this.backing = listBuilder;
        this.root = listBuilder2;
    }

    public ListBuilder() {
        this(10);
    }

    public ListBuilder(int n) {
        this(ListBuilderKt.arrayOfUninitializedElements(n), 0, 0, false, null, null);
    }

    private final void ensureCapacity(int n) {
        if (this.backing == null) {
            if (n >= 0) {
                Object[] objectArray = this.array;
                if (n > this.array.length) {
                    int n2 = ArrayDeque.Companion.newCapacity$kotlin_stdlib(objectArray.length, n);
                    this.array = ListBuilderKt.copyOfUninitializedElements(this.array, n2);
                }
                return;
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    private final void checkIsMutable() {
        if (!this.isEffectivelyReadOnly()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    private final boolean isEffectivelyReadOnly() {
        return this.isReadOnly || (this = this.root) != null && this.isReadOnly;
    }

    private final void ensureExtraCapacity(int n) {
        ListBuilder listBuilder = this;
        listBuilder.ensureCapacity(listBuilder.length + n);
    }

    private final boolean contentEquals(List list) {
        ListBuilder listBuilder = this;
        int n = listBuilder.offset;
        return ListBuilderKt.access$subarrayContentEquals(this.array, n, listBuilder.length, list);
    }

    private final void insertAtInternal(int n, int n2) {
        ListBuilder listBuilder = this;
        listBuilder.ensureExtraCapacity(n2);
        int n3 = this.offset + this.length;
        ArraysKt.copyInto(listBuilder.array, listBuilder.array, n + n2, n, n3);
        listBuilder.length += n2;
    }

    private final void addAtInternal(int n, Object object) {
        ListBuilder listBuilder = this.backing;
        if (listBuilder != null) {
            ListBuilder listBuilder2 = this;
            listBuilder.addAtInternal(n, object);
            listBuilder2.array = listBuilder2.backing.array;
            ++listBuilder2.length;
        } else {
            ListBuilder listBuilder3 = this;
            listBuilder3.insertAtInternal(n, 1);
            listBuilder3.array[n] = object;
        }
    }

    private final void addAllInternal(int n, Collection collection, int n2) {
        Object object = this.backing;
        if (object != null) {
            ListBuilder listBuilder = this;
            ((ListBuilder)object).addAllInternal(n, collection, n2);
            listBuilder.array = listBuilder.backing.array;
            listBuilder.length += n2;
        } else {
            this.insertAtInternal(n, n2);
            object = collection.iterator();
            for (int i = 0; i < n2; ++i) {
                int n3 = n + i;
                this.array[n3] = object.next();
            }
        }
    }

    private final Object removeAtInternal(int n) {
        Object[] objectArray = this.backing;
        if (this.backing != null) {
            this.length += -1;
            return objectArray.removeAtInternal(n);
        }
        objectArray = this.array;
        Object object = this.array[n];
        ListBuilder listBuilder = this;
        int n2 = n + 1;
        int n3 = this.offset + this.length;
        ArraysKt.copyInto(objectArray, objectArray, n, n2, n3);
        ListBuilderKt.resetAt(listBuilder.array, this.offset + this.length - 1);
        listBuilder.length += -1;
        return object;
    }

    private final void removeRangeInternal(int n, int n2) {
        ListBuilder listBuilder = this.backing;
        if (listBuilder != null) {
            listBuilder.removeRangeInternal(n, n2);
        } else {
            ListBuilder listBuilder2 = this;
            int n3 = n + n2;
            int n4 = this.length;
            ArraysKt.copyInto(listBuilder2.array, listBuilder2.array, n, n3, n4);
            n = this.length;
            ListBuilderKt.resetRange(listBuilder2.array, n - n2, n);
        }
        this.length -= n2;
    }

    private final int retainOrRemoveAllInternal(int n, int n2, Collection collection, boolean bl) {
        ListBuilder listBuilder = this.backing;
        if (listBuilder != null) {
            n = listBuilder.retainOrRemoveAllInternal(n, n2, collection, bl);
            this.length -= n;
            return n;
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = n + n3;
            if (collection.contains(this.array[n5]) == bl) {
                int n6 = n4 + 1;
                n4 = n + n4;
                ++n3;
                this.array[n4] = this.array[n5];
                n4 = n6;
                continue;
            }
            ++n3;
        }
        int n7 = n2 - n4;
        ListBuilder listBuilder2 = this;
        int n8 = n;
        n += n2;
        n2 = this.length;
        ArraysKt.copyInto(listBuilder2.array, listBuilder2.array, n8 + n4, n, n2);
        int n9 = this.length;
        ListBuilderKt.resetRange(listBuilder2.array, n9 - n7, n9);
        listBuilder2.length -= n7;
        return n7;
    }

    public static final /* synthetic */ int access$getLength$p(ListBuilder listBuilder) {
        return listBuilder.length;
    }

    public static final /* synthetic */ Object[] access$getArray$p(ListBuilder listBuilder) {
        return listBuilder.array;
    }

    public static final /* synthetic */ int access$getOffset$p(ListBuilder listBuilder) {
        return listBuilder.offset;
    }
}

