/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.ArraysKt___ArraysJvmKt;
import kotlin.collections.ArraysKt___ArraysKt$asIterable$$inlined$Iterable$1;
import kotlin.collections.ArraysKt___ArraysKt$asSequence$$inlined$Sequence$1;
import kotlin.collections.ArraysKt___ArraysKt$withIndex$1;
import kotlin.collections.CollectionsKt;
import kotlin.collections.CollectionsKt__CollectionsKt;
import kotlin.collections.IndexingIterable;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

abstract class ArraysKt___ArraysKt
extends ArraysKt___ArraysJvmKt {
    public static boolean contains(Object[] objectArray, Object object) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return ArraysKt.indexOf(objectArray, object) >= 0;
    }

    public static final boolean contains(int[] nArray, int n) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        return ArraysKt___ArraysKt.indexOf(nArray, n) >= 0;
    }

    public static Object first(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (!(objectArray.length == 0)) {
            return objectArray[0];
        }
        throw new NoSuchElementException("Array is empty.");
    }

    public static Object firstOrNull(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return objectArray.length == 0 ? null : objectArray[0];
    }

    public static Object getOrNull(Object[] objectArray, int n) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return n >= 0 && n <= ArraysKt.getLastIndex(objectArray) ? objectArray[n] : null;
    }

    public static Integer getOrNull(int[] nArray, int n) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        return n >= 0 && n <= ArraysKt___ArraysKt.getLastIndex(nArray) ? Integer.valueOf(nArray[n]) : null;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (object == null) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual(object, objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static final int indexOf(int[] nArray, int n) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static Object last(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (!(objectArray.length == 0)) {
            return objectArray[ArraysKt.getLastIndex(objectArray)];
        }
        throw new NoSuchElementException("Array is empty.");
    }

    public static final int lastIndexOf(int[] nArray, int n) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        int n2 = nArray.length + -1;
        if (n2 >= 0) {
            while (true) {
                int n3 = n2;
                int n4 = n3 + -1;
                if (n == nArray[n3]) {
                    return n2;
                }
                if (n4 < 0) break;
                n2 = n4;
            }
        }
        return -1;
    }

    public static Object single(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        int n = objectArray.length;
        if (n != 0) {
            if (n == 1) {
                return objectArray[0];
            }
            throw new IllegalArgumentException("Array has more than one element.");
        }
        throw new NoSuchElementException("Array is empty.");
    }

    public static char single(char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        int n = cArray.length;
        if (n != 0) {
            if (n == 1) {
                return cArray[0];
            }
            throw new IllegalArgumentException("Array has more than one element.");
        }
        throw new NoSuchElementException("Array is empty.");
    }

    public static Object singleOrNull(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return objectArray.length == 1 ? objectArray[0] : null;
    }

    public static final List filterNotNull(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return (List)ArraysKt___ArraysKt.filterNotNullTo(objectArray, new ArrayList());
    }

    public static final Collection filterNotNullTo(Object[] objectArray, Collection collection) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(collection, "destination");
        for (Object object : objectArray) {
            if (object == null) continue;
            collection.add(object);
        }
        return collection;
    }

    public static final Object[] sortedArrayWith(Object[] objectArray, Comparator comparator) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(comparator, "comparator");
        if (objectArray.length == 0) {
            return objectArray;
        }
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(this, size)");
        ArraysKt___ArraysJvmKt.sortWith(objectArray2, comparator);
        return objectArray2;
    }

    public static List sortedWith(Object[] objectArray, Comparator comparator) {
        Comparator comparator2 = comparator;
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(comparator2, "comparator");
        return ArraysKt.asList(ArraysKt___ArraysKt.sortedArrayWith(objectArray, comparator2));
    }

    public static int getLastIndex(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return objectArray.length - 1;
    }

    public static final int getLastIndex(int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        return nArray.length - 1;
    }

    public static final Collection toCollection(Object[] objectArray, Collection collection) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(collection, "destination");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            collection.add(objectArray[i]);
        }
        return collection;
    }

    public static List toList(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        int n = objectArray.length;
        return n != 0 ? (n != 1 ? ArraysKt.toMutableList(objectArray) : CollectionsKt.listOf(objectArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<this>");
        int n = byArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(byArray) : CollectionsKt.listOf((Object)byArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(short[] sArray) {
        Intrinsics.checkNotNullParameter(sArray, "<this>");
        int n = sArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(sArray) : CollectionsKt.listOf((Object)sArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(int[] nArray) {
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        int n = nArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(nArray) : CollectionsKt.listOf((Object)nArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(long[] lArray) {
        Intrinsics.checkNotNullParameter(lArray, "<this>");
        int n = lArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(lArray) : CollectionsKt.listOf((Object)lArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(float[] fArray) {
        Intrinsics.checkNotNullParameter(fArray, "<this>");
        int n = fArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(fArray) : CollectionsKt.listOf((Object)Float.valueOf(fArray[0]))) : CollectionsKt.emptyList();
    }

    public static List toList(double[] dArray) {
        Intrinsics.checkNotNullParameter(dArray, "<this>");
        int n = dArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(dArray) : CollectionsKt.listOf((Object)dArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(boolean[] blArray) {
        Intrinsics.checkNotNullParameter(blArray, "<this>");
        int n = blArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(blArray) : CollectionsKt.listOf((Object)blArray[0])) : CollectionsKt.emptyList();
    }

    public static List toList(char[] cArray) {
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        int n = cArray.length;
        return n != 0 ? (n != 1 ? ArraysKt___ArraysKt.toMutableList(cArray) : CollectionsKt.listOf((Object)Character.valueOf(cArray[0]))) : CollectionsKt.emptyList();
    }

    public static List toMutableList(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        return new ArrayList(CollectionsKt__CollectionsKt.asCollection(objectArray));
    }

    public static final List toMutableList(byte[] byArray) {
        ArrayList<Byte> arrayList;
        Intrinsics.checkNotNullParameter(byArray, "<this>");
        ArrayList<Byte> arrayList2 = arrayList;
        arrayList = new ArrayList<Byte>(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(byArray[i]);
        }
        return arrayList2;
    }

    public static final List toMutableList(short[] sArray) {
        ArrayList<Short> arrayList;
        Intrinsics.checkNotNullParameter(sArray, "<this>");
        ArrayList<Short> arrayList2 = arrayList;
        arrayList = new ArrayList<Short>(sArray.length);
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(sArray[i]);
        }
        return arrayList2;
    }

    public static final List toMutableList(int[] nArray) {
        ArrayList<Integer> arrayList;
        Intrinsics.checkNotNullParameter(nArray, "<this>");
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>(nArray.length);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(nArray[i]);
        }
        return arrayList2;
    }

    public static final List toMutableList(long[] lArray) {
        ArrayList<Long> arrayList;
        Intrinsics.checkNotNullParameter(lArray, "<this>");
        ArrayList<Long> arrayList2 = arrayList;
        arrayList = new ArrayList<Long>(lArray.length);
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(lArray[i]);
        }
        return arrayList2;
    }

    public static final List toMutableList(float[] fArray) {
        ArrayList<Float> arrayList;
        Intrinsics.checkNotNullParameter(fArray, "<this>");
        ArrayList<Float> arrayList2 = arrayList;
        arrayList = new ArrayList<Float>(fArray.length);
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(Float.valueOf(fArray[i]));
        }
        return arrayList2;
    }

    public static final List toMutableList(double[] dArray) {
        ArrayList<Double> arrayList;
        Intrinsics.checkNotNullParameter(dArray, "<this>");
        ArrayList<Double> arrayList2 = arrayList;
        arrayList = new ArrayList<Double>(dArray.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(dArray[i]);
        }
        return arrayList2;
    }

    public static final List toMutableList(boolean[] blArray) {
        ArrayList<Boolean> arrayList;
        Intrinsics.checkNotNullParameter(blArray, "<this>");
        ArrayList<Boolean> arrayList2 = arrayList;
        arrayList = new ArrayList<Boolean>(blArray.length);
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(blArray[i]);
        }
        return arrayList2;
    }

    public static final List toMutableList(char[] cArray) {
        ArrayList<Character> arrayList;
        Intrinsics.checkNotNullParameter(cArray, "<this>");
        ArrayList<Character> arrayList2 = arrayList;
        arrayList = new ArrayList<Character>(cArray.length);
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(Character.valueOf(cArray[i]));
        }
        return arrayList2;
    }

    public static Set toSet(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        int n = objectArray.length;
        return n != 0 ? (n != 1 ? (Set)ArraysKt___ArraysKt.toCollection(objectArray, new LinkedHashSet(MapsKt.mapCapacity(objectArray.length))) : SetsKt.setOf(objectArray[0])) : SetsKt.emptySet();
    }

    public static List map(Object[] objectArray, Function1 function1) {
        ArrayList<Object> arrayList;
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(function1, "transform");
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>(objectArray.length);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(function1.invoke(objectArray[i]));
        }
        return arrayList2;
    }

    public static Iterable withIndex(Object[] objectArray) {
        ArraysKt___ArraysKt$withIndex$1 arraysKt___ArraysKt$withIndex$1;
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        ArraysKt___ArraysKt$withIndex$1 arraysKt___ArraysKt$withIndex$12 = arraysKt___ArraysKt$withIndex$1;
        arraysKt___ArraysKt$withIndex$1 = new ArraysKt___ArraysKt$withIndex$1(objectArray);
        return new IndexingIterable(arraysKt___ArraysKt$withIndex$12);
    }

    public static List zip(Object[] objectArray, Object[] objectArray2) {
        ArrayList<Pair> arrayList;
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(objectArray2, "other");
        int n = Math.min(objectArray.length, objectArray2.length);
        ArrayList<Pair> arrayList2 = arrayList;
        arrayList = new ArrayList<Pair>(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(TuplesKt.to(objectArray[i], objectArray2[i]));
        }
        return arrayList2;
    }

    public static final Appendable joinTo(Object[] objectArray, Appendable appendable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(appendable, "buffer");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        Intrinsics.checkNotNullParameter(charSequence3, "postfix");
        Intrinsics.checkNotNullParameter(charSequence4, "truncated");
        appendable.append(charSequence2);
        int n2 = 0;
        for (Object object : objectArray) {
            if (++n2 > 1) {
                appendable.append(charSequence);
            }
            if (n >= 0 && n2 > n) break;
            StringsKt.appendElement(appendable, object, function1);
        }
        if (n >= 0 && n2 > n) {
            appendable.append(charSequence4);
        }
        Appendable appendable2 = appendable;
        appendable2.append(charSequence3);
        return appendable2;
    }

    public static /* synthetic */ Appendable joinTo$default(Object[] objectArray, Appendable appendable, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 4) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 8) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        return ArraysKt___ArraysKt.joinTo(objectArray, appendable, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static final String joinToString(Object[] objectArray, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        Intrinsics.checkNotNullParameter(charSequence3, "postfix");
        Intrinsics.checkNotNullParameter(charSequence4, "truncated");
        String string = ((StringBuilder)ArraysKt___ArraysKt.joinTo(objectArray, new StringBuilder(), charSequence, charSequence2, charSequence3, n, charSequence4, function1)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "joinTo(StringBuilder(), \u2026ed, transform).toString()");
        return string;
    }

    public static /* synthetic */ String joinToString$default(Object[] objectArray, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return ArraysKt___ArraysKt.joinToString(objectArray, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static Iterable asIterable(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (objectArray.length == 0) {
            return CollectionsKt.emptyList();
        }
        return new ArraysKt___ArraysKt$asIterable$$inlined$Iterable$1(objectArray);
    }

    public static Sequence asSequence(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "<this>");
        if (objectArray.length == 0) {
            return SequencesKt.emptySequence();
        }
        return new ArraysKt___ArraysKt$asSequence$$inlined$Sequence$1(objectArray);
    }
}

