/*
 * Decompiled with CFR 0.152.
 */
package net.yezon.theabyss.eventhandlers;

import com.mojang.blaze3d.shaders.FogShape;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DimensionFogEventHandlers {
    private static ViewportEvent.RenderFog _provider = null;

    private static void setDistance(float start, float end) {
        _provider.setNearPlaneDistance(start);
        _provider.setFarPlaneDistance(end);
        if (!_provider.isCanceled()) {
            _provider.setCanceled(true);
        }
    }

    private static void setShape(FogShape shape) {
        _provider.setFogShape(shape);
        if (!_provider.isCanceled()) {
            _provider.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        _provider = event;
        if (_provider.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Entity entity = _provider.getCamera().m_90592_();
            if (level != null && entity != null) {
                Vec3 entPos = entity.m_20318_((float)_provider.getPartialTick());
                DimensionFogEventHandlers.execute((Event)_provider, (LevelAccessor)level);
            }
        }
    }

    public static void execute(LevelAccessor world) {
        DimensionFogEventHandlers.execute(null, world);
    }

    private static void execute(@Nullable Event event, LevelAccessor world) {
        ResourceKey resourceKey;
        ResourceKey resourceKey2;
        ResourceKey resourceKey3;
        Level _lvl;
        if (world instanceof Level) {
            _lvl = (Level)world;
            resourceKey3 = _lvl.m_46472_();
        } else {
            resourceKey3 = Level.f_46428_;
        }
        if (resourceKey3 == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theabyss:the_abyss"))) {
            DimensionFogEventHandlers.setShape(FogShape.SPHERE);
            DimensionFogEventHandlers.setDistance(16.0f, 50.0f);
        }
        if (world instanceof Level) {
            _lvl = (Level)world;
            resourceKey2 = _lvl.m_46472_();
        } else {
            resourceKey2 = Level.f_46428_;
        }
        if (resourceKey2 == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theabyss:frost_world"))) {
            DimensionFogEventHandlers.setShape(FogShape.SPHERE);
            DimensionFogEventHandlers.setDistance(10.0f, 32.0f);
        }
        if (world instanceof Level) {
            _lvl = (Level)world;
            resourceKey = _lvl.m_46472_();
        } else {
            resourceKey = Level.f_46428_;
        }
        if (resourceKey == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("theabyss:spectral_world"))) {
            DimensionFogEventHandlers.setShape(FogShape.SPHERE);
            DimensionFogEventHandlers.setDistance(20.0f, 54.0f);
        }
    }
}

