/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.grim_and_bleak.network;

import java.util.function.Supplier;
import net.mcreator.grim_and_bleak.GrimAndBleakMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GrimAndBleakModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GrimAndBleakMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        GrimAndBleakMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.MustShowPossessedOverlay = message.data.MustShowPossessedOverlay;
                    variables.lightX = message.data.lightX;
                    variables.lightY = message.data.lightY;
                    variables.lightZ = message.data.lightZ;
                    variables.darksteelarmors = message.data.darksteelarmors;
                    variables.PX = message.data.PX;
                    variables.PY = message.data.PY;
                    variables.PZ = message.data.PZ;
                    variables.CamShake = message.data.CamShake;
                    variables.lightarmorpieces = message.data.lightarmorpieces;
                    variables.heavyarmorpieces = message.data.heavyarmorpieces;
                    variables.sX = message.data.sX;
                    variables.sY = message.data.sY;
                    variables.sZ = message.data.sZ;
                    variables.decaydelay = message.data.decaydelay;
                    variables.MustShowAbsolutePain = message.data.MustShowAbsolutePain;
                    variables.IsTheGateKeeper = message.data.IsTheGateKeeper;
                    variables.worthiness = message.data.worthiness;
                    variables.ritual_number = message.data.ritual_number;
                    variables.chosenabilitycooldown = message.data.chosenabilitycooldown;
                    variables.abilityduration = message.data.abilityduration;
                    variables.Armor0 = message.data.Armor0;
                    variables.Armor1 = message.data.Armor1;
                    variables.Armor2 = message.data.Armor2;
                    variables.Armor3 = message.data.Armor3;
                    variables.PredDaggerItem = message.data.PredDaggerItem;
                    variables.gatex = message.data.gatex;
                    variables.gatez = message.data.gatez;
                    variables.heartbleat_frame = message.data.heartbleat_frame;
                    variables.mustshowthorns = message.data.mustshowthorns;
                    variables.damned = message.data.damned;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double MustShowPossessedOverlay = 0.0;
        public double lightX = 0.0;
        public double lightY = 0.0;
        public double lightZ = 0.0;
        public double darksteelarmors = 0.0;
        public double PX = 0.0;
        public double PY = 0.0;
        public double PZ = 0.0;
        public double CamShake = 0.0;
        public double lightarmorpieces = 0.0;
        public double heavyarmorpieces = 0.0;
        public double sX = 0.0;
        public double sY = 0.0;
        public double sZ = 0.0;
        public double decaydelay = 0.0;
        public double MustShowAbsolutePain = 0.0;
        public boolean IsTheGateKeeper = false;
        public double worthiness = 0.0;
        public double ritual_number = 0.0;
        public boolean chosenabilitycooldown = false;
        public double abilityduration = 0.0;
        public ItemStack Armor0 = ItemStack.f_41583_;
        public ItemStack Armor1 = ItemStack.f_41583_;
        public ItemStack Armor2 = ItemStack.f_41583_;
        public ItemStack Armor3 = ItemStack.f_41583_;
        public ItemStack PredDaggerItem = ItemStack.f_41583_;
        public double gatex = 0.0;
        public double gatez = 0.0;
        public double heartbleat_frame = 0.0;
        public double mustshowthorns = -1.0;
        public boolean damned = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GrimAndBleakMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("MustShowPossessedOverlay", this.MustShowPossessedOverlay);
            nbt.m_128347_("lightX", this.lightX);
            nbt.m_128347_("lightY", this.lightY);
            nbt.m_128347_("lightZ", this.lightZ);
            nbt.m_128347_("darksteelarmors", this.darksteelarmors);
            nbt.m_128347_("PX", this.PX);
            nbt.m_128347_("PY", this.PY);
            nbt.m_128347_("PZ", this.PZ);
            nbt.m_128347_("CamShake", this.CamShake);
            nbt.m_128347_("lightarmorpieces", this.lightarmorpieces);
            nbt.m_128347_("heavyarmorpieces", this.heavyarmorpieces);
            nbt.m_128347_("sX", this.sX);
            nbt.m_128347_("sY", this.sY);
            nbt.m_128347_("sZ", this.sZ);
            nbt.m_128347_("decaydelay", this.decaydelay);
            nbt.m_128347_("MustShowAbsolutePain", this.MustShowAbsolutePain);
            nbt.m_128379_("IsTheGateKeeper", this.IsTheGateKeeper);
            nbt.m_128347_("worthiness", this.worthiness);
            nbt.m_128347_("ritual_number", this.ritual_number);
            nbt.m_128379_("chosenabilitycooldown", this.chosenabilitycooldown);
            nbt.m_128347_("abilityduration", this.abilityduration);
            nbt.m_128365_("Armor0", (Tag)this.Armor0.m_41739_(new CompoundTag()));
            nbt.m_128365_("Armor1", (Tag)this.Armor1.m_41739_(new CompoundTag()));
            nbt.m_128365_("Armor2", (Tag)this.Armor2.m_41739_(new CompoundTag()));
            nbt.m_128365_("Armor3", (Tag)this.Armor3.m_41739_(new CompoundTag()));
            nbt.m_128365_("PredDaggerItem", (Tag)this.PredDaggerItem.m_41739_(new CompoundTag()));
            nbt.m_128347_("gatex", this.gatex);
            nbt.m_128347_("gatez", this.gatez);
            nbt.m_128347_("heartbleat_frame", this.heartbleat_frame);
            nbt.m_128347_("mustshowthorns", this.mustshowthorns);
            nbt.m_128379_("damned", this.damned);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.MustShowPossessedOverlay = nbt.m_128459_("MustShowPossessedOverlay");
            this.lightX = nbt.m_128459_("lightX");
            this.lightY = nbt.m_128459_("lightY");
            this.lightZ = nbt.m_128459_("lightZ");
            this.darksteelarmors = nbt.m_128459_("darksteelarmors");
            this.PX = nbt.m_128459_("PX");
            this.PY = nbt.m_128459_("PY");
            this.PZ = nbt.m_128459_("PZ");
            this.CamShake = nbt.m_128459_("CamShake");
            this.lightarmorpieces = nbt.m_128459_("lightarmorpieces");
            this.heavyarmorpieces = nbt.m_128459_("heavyarmorpieces");
            this.sX = nbt.m_128459_("sX");
            this.sY = nbt.m_128459_("sY");
            this.sZ = nbt.m_128459_("sZ");
            this.decaydelay = nbt.m_128459_("decaydelay");
            this.MustShowAbsolutePain = nbt.m_128459_("MustShowAbsolutePain");
            this.IsTheGateKeeper = nbt.m_128471_("IsTheGateKeeper");
            this.worthiness = nbt.m_128459_("worthiness");
            this.ritual_number = nbt.m_128459_("ritual_number");
            this.chosenabilitycooldown = nbt.m_128471_("chosenabilitycooldown");
            this.abilityduration = nbt.m_128459_("abilityduration");
            this.Armor0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Armor0"));
            this.Armor1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Armor1"));
            this.Armor2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Armor2"));
            this.Armor3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Armor3"));
            this.PredDaggerItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("PredDaggerItem"));
            this.gatex = nbt.m_128459_("gatex");
            this.gatez = nbt.m_128459_("gatez");
            this.heartbleat_frame = nbt.m_128459_("heartbleat_frame");
            this.mustshowthorns = nbt.m_128459_("mustshowthorns");
            this.damned = nbt.m_128471_("damned");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("grim_and_bleak", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "grim_and_bleak_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                GrimAndBleakMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "grim_and_bleak_worldvars";
        public boolean PortalBreached = false;
        public double stormy = 0.0;
        public double stormy2 = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.PortalBreached = nbt.m_128471_("PortalBreached");
            this.stormy = nbt.m_128459_("stormy");
            this.stormy2 = nbt.m_128459_("stormy2");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("PortalBreached", this.PortalBreached);
            nbt.m_128347_("stormy", this.stormy);
            nbt.m_128347_("stormy2", this.stormy2);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                GrimAndBleakMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.lightX = original.lightX;
            clone.lightY = original.lightY;
            clone.lightZ = original.lightZ;
            clone.PX = original.PX;
            clone.PY = original.PY;
            clone.PZ = original.PZ;
            clone.sX = original.sX;
            clone.sY = original.sY;
            clone.sZ = original.sZ;
            clone.IsTheGateKeeper = original.IsTheGateKeeper;
            clone.worthiness = original.worthiness;
            clone.gatex = original.gatex;
            clone.gatez = original.gatez;
            clone.damned = original.damned;
            if (!event.isWasDeath()) {
                clone.MustShowPossessedOverlay = original.MustShowPossessedOverlay;
                clone.darksteelarmors = original.darksteelarmors;
                clone.CamShake = original.CamShake;
                clone.lightarmorpieces = original.lightarmorpieces;
                clone.heavyarmorpieces = original.heavyarmorpieces;
                clone.decaydelay = original.decaydelay;
                clone.MustShowAbsolutePain = original.MustShowAbsolutePain;
                clone.ritual_number = original.ritual_number;
                clone.chosenabilitycooldown = original.chosenabilitycooldown;
                clone.abilityduration = original.abilityduration;
                clone.Armor0 = original.Armor0;
                clone.Armor1 = original.Armor1;
                clone.Armor2 = original.Armor2;
                clone.Armor3 = original.Armor3;
                clone.PredDaggerItem = original.PredDaggerItem;
                clone.heartbleat_frame = original.heartbleat_frame;
                clone.mustshowthorns = original.mustshowthorns;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    GrimAndBleakMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    GrimAndBleakMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                GrimAndBleakMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

