/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.unusual.blockfactorysbosses.BlockFactorysBossesMod;

public class DragonTowerStructure
extends Structure {
    public static final Codec<DragonTowerStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DragonTowerStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)160).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, DragonTowerStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public DragonTowerStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int y = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos startPos = new BlockPos(chunkpos.m_45604_(), y, chunkpos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)startPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public void m_214110_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, PiecesContainer pieces) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minBuildHeight = level.m_141937_();
        BoundingBox structureBox = pieces.m_192756_();
        int baseY = structureBox.m_162396_();
        for (int x = box.m_162395_(); x <= box.m_162399_(); ++x) {
            block1: for (int z = box.m_162398_(); z <= box.m_162401_(); ++z) {
                pos.m_122178_(x, baseY, z);
                if (level.m_46859_((BlockPos)pos) || !structureBox.m_71051_((Vec3i)pos) || !pieces.m_192751_((BlockPos)pos)) continue;
                for (int y = baseY - 1; y > minBuildHeight; --y) {
                    pos.m_142448_(y);
                    if (level.m_8055_((BlockPos)pos).m_60815_()) continue block1;
                    level.m_7731_((BlockPos)pos, Blocks.f_152551_.m_49966_(), 2);
                }
            }
        }
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BlockFactorysBossesMod.DRAGON_TOWER.get();
    }
}

