/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.extensions;

import guideme.document.block.LytSlotGrid;
import guideme.document.block.recipes.LytStandardRecipeBox;
import guideme.internal.GuidebookText;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VanillaRecipes {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaRecipes.class);

    private VanillaRecipes() {
    }

    public static LytStandardRecipeBox<CraftingRecipe> createCrafting(CraftingRecipe recipe) {
        LytSlotGrid grid;
        NonNullList ingredients = recipe.m_7527_();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            grid = new LytSlotGrid(shapedRecipe.m_44220_(), shapedRecipe.m_44221_());
            for (int x = 0; x < shapedRecipe.m_44220_(); ++x) {
                for (int y = 0; y < shapedRecipe.m_44221_(); ++y) {
                    Ingredient ingredient;
                    int index = y * shapedRecipe.m_44220_() + x;
                    if (index >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(index)).m_43947_()) continue;
                    grid.setIngredient(x, y, ingredient);
                }
            }
        } else {
            int ingredientCount = ingredients.size();
            grid = new LytSlotGrid(Math.min(3, ingredientCount), (ingredientCount + 2) / 3);
            for (int i = 0; i < ingredients.size(); ++i) {
                int col = i % 3;
                int row = i / 3;
                grid.setIngredient(col, row, (Ingredient)ingredients.get(i));
            }
        }
        String title = recipe instanceof ShapedRecipe ? GuidebookText.Crafting.text().getString() : GuidebookText.ShapelessCrafting.text().getString();
        return LytStandardRecipeBox.builder().title(title).icon((ItemLike)Blocks.f_50091_).input(grid).outputFromResultOf((Recipe<?>)recipe).build(recipe);
    }

    public static LytStandardRecipeBox<SmeltingRecipe> createSmelting(SmeltingRecipe recipe) {
        return LytStandardRecipeBox.builder().title(GuidebookText.Smelting.text().getString()).icon((ItemLike)Blocks.f_50094_).input(LytSlotGrid.row((List<Ingredient>)recipe.m_7527_(), true)).outputFromResultOf((Recipe<?>)recipe).build(recipe);
    }

    public static LytStandardRecipeBox<BlastingRecipe> createBlasting(BlastingRecipe recipe) {
        return LytStandardRecipeBox.builder().title(GuidebookText.Blasting.text().getString()).icon((ItemLike)Blocks.f_50620_).input(LytSlotGrid.row((List<Ingredient>)recipe.m_7527_(), true)).outputFromResultOf((Recipe<?>)recipe).build(recipe);
    }

    public static LytStandardRecipeBox<SmithingRecipe> createSmithing(SmithingRecipe recipe) {
        return LytStandardRecipeBox.builder().icon((ItemLike)Blocks.f_50625_).title(Items.f_42775_.m_41466_().getString()).input(LytSlotGrid.row(VanillaRecipes.getSmithingIngredients(recipe), true)).outputFromResultOf((Recipe<?>)recipe).build(recipe);
    }

    private static List<Ingredient> getSmithingIngredients(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return List.of(trimRecipe.f_265958_, trimRecipe.f_266040_, trimRecipe.f_266053_);
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return List.of(transformRecipe.f_265949_, transformRecipe.f_265888_, transformRecipe.f_265907_);
        }
        LOG.warn("Cannot determine ingredients of smithing recipe type {}", recipe.getClass());
        return List.of();
    }
}

