/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.lib.executable;

import com.dannbrown.musicbox.common.lib.executable.DownloadManager;
import com.dannbrown.musicbox.common.lib.main.Manager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u00020\u00062\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/dannbrown/musicbox/common/lib/executable/YoutubeDL;", "", "<init>", "()V", "", "checkForExecutable", "", "checkForUpdates", "()Z", "", "", "arguments", "executeCommand", "([Ljava/lang/String;)Z", "FILENAME", "Ljava/lang/String;", "getFILENAME", "()Ljava/lang/String;", "Ljava/io/File;", "DIRECTORY", "Ljava/io/File;", "REPOSITORY_FILE", "REPOSITORY_NAME", "musicbox-forge"})
public final class YoutubeDL {
    @NotNull
    public static final YoutubeDL INSTANCE;
    @NotNull
    private static final String FILENAME;
    @Nullable
    private static final File DIRECTORY;
    @NotNull
    private static final String REPOSITORY_FILE;
    @NotNull
    private static final String REPOSITORY_NAME = "yt-dlp/yt-dlp";

    private YoutubeDL() {
    }

    @NotNull
    public final String getFILENAME() {
        return FILENAME;
    }

    public final void checkForExecutable() throws IOException, URISyntaxException {
        if (DIRECTORY == null) {
            return;
        }
        DownloadManager.INSTANCE.checkForFile(FILENAME, DIRECTORY, REPOSITORY_FILE, REPOSITORY_NAME);
    }

    public final boolean checkForUpdates() {
        if (DIRECTORY == null) {
            return false;
        }
        return DownloadManager.INSTANCE.checkForUpdates(FILENAME, DIRECTORY, REPOSITORY_FILE, REPOSITORY_NAME);
    }

    public final boolean executeCommand(String ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (DIRECTORY == null) {
            return false;
        }
        return DownloadManager.INSTANCE.runFileCommand(DIRECTORY, Arrays.copyOf(arguments, arguments.length));
    }

    static {
        File file;
        INSTANCE = new YoutubeDL();
        FILENAME = "yt-dlp" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        if (Manager.INSTANCE.getPATH() != null) {
            Path path = Manager.INSTANCE.getPATH();
            Intrinsics.checkNotNull((Object)path);
            file = path.resolve("youtubedl").toFile();
        } else {
            file = null;
        }
        DIRECTORY = file;
        String string = "yt-dlp%s";
        Object[] objectArray = new Object[]{SystemUtils.IS_OS_LINUX ? "_linux" : (SystemUtils.IS_OS_MAC ? "_macos" : ".exe")};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        REPOSITORY_FILE = string2;
    }
}

