/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.lib.executable;

import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import com.dannbrown.musicbox.common.lib.executable.FFmpeg;
import com.dannbrown.musicbox.common.lib.executable.YoutubeDL;
import com.dannbrown.musicbox.common.lib.main.Manager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010!\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001f\"\u00020\u0004\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lcom/dannbrown/musicbox/common/lib/executable/DownloadManager;", "", "<init>", "()V", "", "fileName", "Ljava/io/File;", "directory", "repositoryFile", "repositoryName", "", "checkForFile", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "", "checkForUpdates", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)Z", "Ljava/nio/file/Path;", "filePath", "downloadFile", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "version", "versionFilePath", "createVersionFile", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "currentVersion", "(Ljava/nio/file/Path;)Ljava/lang/String;", "latestVersion", "(Ljava/lang/String;)Ljava/lang/String;", "Ljava/io/InputStream;", "getDownloadInputStream", "(Ljava/lang/String;Ljava/lang/String;)Ljava/io/InputStream;", "", "arguments", "runFileCommand", "(Ljava/io/File;[Ljava/lang/String;)Z", "getFilePath", "(Ljava/lang/String;Ljava/io/File;)Ljava/nio/file/Path;", "musicbox-forge"})
@SourceDebugExtension(value={"SMAP\nDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManager.kt\ncom/dannbrown/musicbox/common/lib/executable/DownloadManager\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n108#2:186\n80#2,22:187\n739#3,9:209\n739#3,9:220\n37#4,2:218\n37#4,2:229\n37#4,2:231\n1#5:233\n*S KotlinDebug\n*F\n+ 1 DownloadManager.kt\ncom/dannbrown/musicbox/common/lib/executable/DownloadManager\n*L\n98#1:186\n98#1:187,22\n116#1:209,9\n119#1:220,9\n117#1:218,2\n120#1:229,2\n159#1:231,2\n*E\n"})
public final class DownloadManager {
    @NotNull
    public static final DownloadManager INSTANCE = new DownloadManager();

    private DownloadManager() {
    }

    public final void checkForFile(@NotNull String fileName, @NotNull File directory, @NotNull String repositoryFile, @NotNull String repositoryName) throws IOException, URISyntaxException {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)repositoryFile, (String)"repositoryFile");
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        Path filePath = this.getFilePath(fileName, directory);
        if (directory.exists() || directory.mkdirs()) {
            if (!filePath.toFile().exists()) {
                this.downloadFile(fileName, filePath, repositoryFile, repositoryName);
            } else if (Manager.INSTANCE.getDO_CHECK_UPDATES_ON_START()) {
                String string = fileName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"ffmpeg", (boolean)false, (int)2, null)) {
                    this.checkForUpdates(fileName, directory, repositoryFile, repositoryName);
                }
            }
        }
    }

    public final boolean checkForUpdates(@NotNull String fileName, @NotNull File directory, @NotNull String repositoryFile, @NotNull String repositoryName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)repositoryFile, (String)"repositoryFile");
        Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
        if (Intrinsics.areEqual((Object)fileName, (Object)"ffmpeg")) {
            return false;
        }
        try {
            Path filePath = this.getFilePath(fileName, directory);
            Path path = filePath.getParent().resolve("version.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            if (!Intrinsics.areEqual((Object)this.currentVersion(path), (Object)this.latestVersion(repositoryName))) {
                Files.deleteIfExists(filePath);
                this.downloadFile(fileName, filePath, repositoryFile, repositoryName);
                return true;
            }
            return false;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadFile(String fileName, Path filePath, String repositoryFile, String repositoryName) throws IOException, URISyntaxException {
        Closeable closeable = this.getDownloadInputStream(repositoryFile, repositoryName);
        Throwable throwable = null;
        try {
            Object object;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            if (StringsKt.endsWith$default((String)repositoryFile, (String)".zip", (boolean)false, (int)2, null)) {
                object = new ZipInputStream(inputStream);
                Throwable throwable2 = null;
                try {
                    ZipInputStream zipInput = (ZipInputStream)object;
                    boolean bl2 = false;
                    ZipEntry zipEntry = zipInput.getNextEntry();
                    while (zipEntry != null) {
                        String string = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (StringsKt.endsWith$default((String)string, (String)fileName, (boolean)false, (int)2, null)) {
                            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.copy(zipInput, filePath, copyOptionArray);
                            break;
                        }
                        zipEntry = zipInput.getNextEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            } else {
                object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(inputStream, filePath, object);
            }
            if (SystemUtils.IS_OS_UNIX) {
                object = new String[]{"chmod", "+x", ((Object)filePath).toString()};
                Runtime.getRuntime().exec((String[])object);
            }
            String string = Intrinsics.areEqual((Object)fileName, (Object)"ffmpeg") ? FFmpeg.INSTANCE.getHARDCODED_VERSION() : INSTANCE.latestVersion(repositoryName);
            Path path = filePath.getParent().resolve("version.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            INSTANCE.createVersionFile(string, path);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createVersionFile(String version, Path versionFilePath) throws IOException {
        Closeable closeable = new FileWriter(versionFilePath.toFile());
        Throwable throwable = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl = false;
            writer.write(version);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String currentVersion(Path filePath) throws IOException {
        Closeable closeable = new BufferedReader(new FileReader(filePath.toFile()));
        Throwable throwable = null;
        try {
            void $this$trim$iv;
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            String string = reader.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
            String string2 = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string3 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            return string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String latestVersion(String repositoryName) {
        try {
            Object object = "https://api.github.com/repos/%s/releases/latest";
            Object[] objectArray = new Object[]{repositoryName};
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            Closeable closeable = new BufferedReader(new InputStreamReader(new URL(string).openStream()));
            object = null;
            try {
                List list;
                Object $this$toTypedArray$iv;
                List list2;
                String it;
                Collection $this$dropLastWhile$iv;
                BufferedReader reader = (BufferedReader)closeable;
                boolean bl = false;
                String string2 = reader.readLine();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readLine(...)");
                Object object2 = string2;
                Regex regex = new Regex("\"tag_name\":\"");
                int n = 0;
                object2 = regex.split((CharSequence)object2, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list2;
                boolean $i$f$toTypedArray22 = false;
                void thisCollection$iv22 = $this$toTypedArray$iv;
                $this$toTypedArray$iv = thisCollection$iv22.toArray(new String[0])[1];
                Regex $i$f$toTypedArray22 = new Regex("\",\"target_commitish\"");
                int thisCollection$iv22 = 0;
                $this$toTypedArray$iv = $i$f$toTypedArray22.split((CharSequence)$this$toTypedArray$iv, thisCollection$iv22);
                $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                Object thisCollection$iv = $this$toTypedArray$iv;
                String string3 = thisCollection$iv.toArray(new String[0])[0];
                return string3;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        catch (IOException e) {
            return "";
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "";
        }
    }

    private final InputStream getDownloadInputStream(String repositoryFile, String repositoryName) throws IOException, URISyntaxException {
        String string = repositoryName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ffmpeg", (boolean)false, (int)2, null)) {
            String string2 = "https://github.com/%s/releases/download/" + FFmpeg.INSTANCE.getHARDCODED_VERSION() + "/%s";
            Object[] objectArray = new Object[]{repositoryName, repositoryFile};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            InputStream inputStream = new URI(string3).toURL().openStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
            return inputStream;
        }
        String string4 = "https://github.com/%s/releases/latest/download/%s";
        Object[] objectArray = new Object[]{repositoryName, repositoryFile};
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        InputStream inputStream = new URI(string5).toURL().openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean runFileCommand(@NotNull File directory, String ... arguments) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String fileName = YoutubeDL.INSTANCE.getFILENAME();
        try {
            Closeable $this$toTypedArray$iv;
            Object object = new String[]{((Object)this.getFilePath(fileName, directory)).toString()};
            object = SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object[])object), (Sequence)ArraysKt.asSequence((Object[])arguments)));
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]));
            $this$toTypedArray$iv = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            Throwable throwable = null;
            try {
                BufferedReader errorReader = (BufferedReader)$this$toTypedArray$iv;
                boolean bl = false;
                String line = null;
                while (true) {
                    String string;
                    String it = string = errorReader.readLine();
                    boolean bl2 = false;
                    line = it;
                    if (string == null) break;
                    DeltaboxUtil.INSTANCE.getLOGGER().info(line);
                }
                if (process.waitFor() != 0) {
                    throw new IOException();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$this$toTypedArray$iv, (Throwable)throwable);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private final Path getFilePath(String fileName, File directory) {
        Path path = directory.toPath().resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

