/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.musicbox.common.lib.client;

import com.dannbrown.musicbox.common.lib.executable.YoutubeDL;
import com.dannbrown.musicbox.common.lib.main.Manager;
import com.dannbrown.musicbox.common.lib.main.YoutubeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/dannbrown/musicbox/common/lib/client/ClientAudioManager;", "", "<init>", "()V", "", "url", "fileName", "Ljava/util/concurrent/CompletableFuture;", "", "downloadAudio", "(Ljava/lang/String;Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Ljava/io/InputStream;", "getAudioInputStream", "(Ljava/lang/String;)Ljava/io/InputStream;", "Ljava/io/File;", "fileNameToFile", "(Ljava/lang/String;)Ljava/io/File;", "musicbox-forge"})
public final class ClientAudioManager {
    @NotNull
    public static final ClientAudioManager INSTANCE = new ClientAudioManager();

    private ClientAudioManager() {
    }

    @NotNull
    public final CompletableFuture<Boolean> downloadAudio(@NotNull String url, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (Manager.INSTANCE.getPATH() == null) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> ClientAudioManager.downloadAudio$lambda$0(url, fileName));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @JvmStatic
    @Nullable
    public static final InputStream getAudioInputStream(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            File file = INSTANCE.fileNameToFile(fileName);
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Nullable
    public final File fileNameToFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (Manager.INSTANCE.getPATH() == null) {
            return null;
        }
        Path path = Manager.INSTANCE.getPATH();
        Intrinsics.checkNotNull((Object)path);
        return new File(((Object)path.resolve("client_downloads/" + fileName)).toString());
    }

    private static final Boolean downloadAudio$lambda$0(String $url, String $fileName) {
        String[] stringArray = new String[18];
        stringArray[0] = YoutubeUtils.INSTANCE.removeUrlParameters($url);
        stringArray[1] = "-x";
        stringArray[2] = "--no-progress";
        stringArray[3] = "--no-playlist";
        stringArray[4] = "--external-downloader-args";
        String string = "\"-ss 00:00:00.00 -to 00:%s:00.00\"";
        Object[] objectArray = new Object[]{Manager.INSTANCE.getMAX_AUDIO_MINUTES()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
        stringArray[6] = "--break-match-filter";
        stringArray[7] = "ext~=3gp|aac|flv|m4a|mov|mp3|mp4|ogg|wav|webm";
        stringArray[8] = "--audio-format";
        stringArray[9] = "vorbis";
        stringArray[10] = "--audio-quality";
        stringArray[11] = Manager.INSTANCE.getAUDIO_BIT_RATE().getValue();
        stringArray[12] = "--postprocessor-args";
        string = "ffmpeg:-ac 1 -t %s";
        objectArray = new Object[]{Manager.INSTANCE.getMAX_AUDIO_MINUTES() * 60};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
        stringArray[14] = "--ffmpeg-location";
        Path path = Manager.INSTANCE.getPATH();
        Intrinsics.checkNotNull((Object)path);
        stringArray[15] = ((Object)path.resolve("ffmpeg")).toString();
        stringArray[16] = "-o";
        stringArray[17] = String.valueOf(INSTANCE.fileNameToFile($fileName));
        return YoutubeDL.INSTANCE.executeCommand(stringArray);
    }
}

