/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.utils;

import com.github.yimeng261.maidspell.mixin.SynchedEntityDataMixin;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.slf4j.Logger;

public class TrueDamageUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float HEALTH_TOLERANCE = 0.01f;
    private static final Map<String, List<Integer>> healthIdMap = new HashMap<String, List<Integer>>();

    public static boolean dealTrueDamage(LivingEntity target, float damage, LivingEntity attacker) {
        boolean success;
        if (target == null) {
            return false;
        }
        float originalHealth = target.m_21223_();
        float newHealth = Math.max(0.0f, originalHealth - damage);
        boolean bl = success = TrueDamageUtil.tryEntityDataDamage(target, newHealth) || TrueDamageUtil.tryNBTDamage(target, originalHealth, newHealth);
        if (newHealth <= 0.0f) {
            target.m_6667_(new DamageSource(Holder.m_205709_((Object)new DamageType("info_damage", 0.0f)), (Entity)attacker));
            target.m_142687_(Entity.RemovalReason.KILLED);
        }
        return success;
    }

    public static boolean setNewHealth(LivingEntity target, float newHealth, LivingEntity attacker) {
        boolean success;
        if (target == null) {
            return false;
        }
        float originalHealth = target.m_21223_();
        boolean bl = success = TrueDamageUtil.tryEntityDataDamage(target, newHealth) || TrueDamageUtil.tryNBTDamage(target, originalHealth, newHealth);
        if (success || newHealth <= 0.0f) {
            target.m_6667_(new DamageSource(Holder.m_205709_((Object)new DamageType("info_damage", 0.0f)), (Entity)attacker));
        }
        return success;
    }

    private static boolean tryEntityDataDamage(LivingEntity target, float newHealth) {
        try {
            SynchedEntityDataMixin dataMixin = (SynchedEntityDataMixin)target.m_20088_();
            Int2ObjectMap<SynchedEntityData.DataItem<?>> itemsById = dataMixin.getItemsById();
            List<Integer> healthIds = TrueDamageUtil.findAllHealthIds(target, itemsById);
            if (healthIds.isEmpty()) {
                return false;
            }
            boolean modified = false;
            for (Integer healthId : healthIds) {
                try {
                    SynchedEntityData.DataItem dataItem = (SynchedEntityData.DataItem)itemsById.get((Object)healthId);
                    target.m_20088_().m_135381_(dataItem.m_135396_(), (Object)Float.valueOf(newHealth));
                    modified = true;
                }
                catch (Exception e) {
                    LOGGER.debug("[TrueDamage] Failed to modify EntityData ID {}: {}", (Object)healthId, (Object)e.getMessage());
                }
            }
            return modified;
        }
        catch (Exception e) {
            LOGGER.debug("[TrueDamage] EntityData damage failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean tryNBTDamage(LivingEntity target, float originalHealth, float newHealth) {
        try {
            CompoundTag nbt = new CompoundTag();
            target.m_20240_(nbt);
            boolean modified = false;
            if (nbt.m_128441_("Health")) {
                nbt.m_128350_("Health", newHealth);
                modified = true;
                LOGGER.debug("[TrueDamage] Modified NBT Health: {}", (Object)Float.valueOf(newHealth));
            }
            if (TrueDamageUtil.modifyFloatValuesInNBT(nbt, originalHealth, newHealth)) {
                modified = true;
            }
            if (modified) {
                target.m_20258_(nbt);
            }
            return modified;
        }
        catch (Exception e) {
            LOGGER.debug("[TrueDamage] NBT damage failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean modifyFloatValuesInNBT(CompoundTag nbt, float originalHealth, float newHealth) {
        boolean modified = false;
        for (String key : nbt.m_128431_()) {
            if (nbt.m_128423_(key) instanceof FloatTag) {
                float value = nbt.m_128457_(key);
                if (!TrueDamageUtil.isHealthMatch(value, originalHealth)) continue;
                nbt.m_128350_(key, newHealth);
                modified = true;
                LOGGER.debug("[TrueDamage] Modified NBT Float {}: {}", (Object)key, (Object)Float.valueOf(newHealth));
                continue;
            }
            if (!(nbt.m_128423_(key) instanceof CompoundTag) || !TrueDamageUtil.modifyFloatValuesInNBT(nbt.m_128469_(key), originalHealth, newHealth)) continue;
            modified = true;
        }
        return modified;
    }

    private static boolean isHealthMatch(float value1, float value2) {
        return Math.abs(value1 - value2) < 0.01f;
    }

    private static List<Integer> findAllHealthIds(LivingEntity target, Int2ObjectMap<SynchedEntityData.DataItem<?>> itemsById) {
        String className = target.getClass().getSimpleName();
        float currentHealth = target.m_21223_();
        List<Integer> cachedIds = healthIdMap.get(className);
        if (cachedIds != null && !cachedIds.isEmpty()) {
            ArrayList<Integer> validIds = new ArrayList<Integer>();
            for (Integer id2 : cachedIds) {
                try {
                    SynchedEntityData.DataItem item = (SynchedEntityData.DataItem)itemsById.get((Object)id2);
                    if (item == null || !(item.m_135403_() instanceof Float)) continue;
                    validIds.add(id2);
                }
                catch (Exception exception) {}
            }
            if (!validIds.isEmpty()) {
                return validIds;
            }
        }
        ArrayList<Integer> healthIds = new ArrayList<Integer>();
        itemsById.forEach((id, dataItem) -> {
            Float floatValue;
            Object patt7877$temp = dataItem.m_135403_();
            if (patt7877$temp instanceof Float && (TrueDamageUtil.isHealthMatch((floatValue = (Float)patt7877$temp).floatValue(), currentHealth) || floatValue.floatValue() > 0.0f && floatValue.floatValue() <= target.m_21233_())) {
                healthIds.add((Integer)id);
            }
        });
        healthIdMap.put(className, healthIds);
        return healthIds;
    }

    public static String getEntityDataInfo(LivingEntity entity) {
        try {
            SynchedEntityDataMixin dataMixin = (SynchedEntityDataMixin)entity.m_20088_();
            Int2ObjectMap<SynchedEntityData.DataItem<?>> itemsById = dataMixin.getItemsById();
            float health = entity.m_21223_();
            String className = entity.getClass().getSimpleName();
            StringBuilder sb = new StringBuilder();
            sb.append("=== EntityData Analysis for ").append(className).append(" ===\n");
            sb.append("Current Health: ").append(health).append("\n");
            sb.append("Max Health: ").append(entity.m_21233_()).append("\n");
            List<Integer> healthIds = TrueDamageUtil.findAllHealthIds(entity, itemsById);
            if (!healthIds.isEmpty()) {
                sb.append("Found Health IDs: ").append(healthIds).append("\n");
            }
            sb.append("\n=== All EntityData Float Values ===\n");
            itemsById.forEach((id, dataItem) -> {
                Object patt9530$temp = dataItem.m_135403_();
                if (patt9530$temp instanceof Float) {
                    Float floatValue = (Float)patt9530$temp;
                    sb.append("  ID ").append(id).append(": ").append(floatValue);
                    if (TrueDamageUtil.isHealthMatch(floatValue.floatValue(), health)) {
                        sb.append(" <- HEALTH MATCH");
                    } else if (floatValue.floatValue() > 0.0f && floatValue.floatValue() <= entity.m_21233_()) {
                        sb.append(" <- Possible Health");
                    }
                    sb.append("\n");
                }
            });
            sb.append("\n=== NBT Health Information ===\n");
            try {
                CompoundTag nbt = new CompoundTag();
                entity.m_20240_(nbt);
                if (nbt.m_128441_("Health")) {
                    sb.append("NBT Health: ").append(nbt.m_128457_("Health")).append("\n");
                }
            }
            catch (Exception e) {
                sb.append("Failed to read NBT: ").append(e.getMessage()).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Failed to access entity data: " + e.getMessage();
        }
    }
}

