/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.utils;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="touhou_little_maid_spell")
public class ChunkLoadingManager {
    private static final Map<UUID, Set<ChunkKey>> maidChunkPositions = new ConcurrentHashMap<UUID, Set<ChunkKey>>();
    private static final Map<ChunkKey, ChunkTimer> chunkTimers = new ConcurrentHashMap<ChunkKey, ChunkTimer>();
    private static final int CHECK_INTERVAL_TICKS = 20;
    private static final int DEFAULT_CHUNK_LIFETIME_TICKS = 200;
    private static final List<ChunkKey> reusableExpiredChunks = new ArrayList<ChunkKey>();

    public static void enableChunkLoading(EntityMaid maid) {
        if (maid == null || maid.m_9236_().m_5776_()) {
            return;
        }
        UUID maidId = maid.m_20148_();
        ServerLevel serverLevel = (ServerLevel)maid.m_9236_();
        ChunkPos chunkPos = maid.m_146902_();
        ChunkKey chunkKey = new ChunkKey(chunkPos, serverLevel);
        ChunkLoadingManager.performChunkOperation(maidId, chunkKey, true);
    }

    public static void preloadTeleportTarget(EntityMaid maid, Vec3 targetPos, ServerLevel level) {
        if (maid == null || targetPos == null) {
            return;
        }
        UUID maidId = maid.m_20148_();
        ChunkPos targetChunk = new ChunkPos(BlockPos.m_274446_((Position)targetPos));
        ChunkKey targetKey = new ChunkKey(targetChunk, level);
        Global.LOGGER.debug("\u5973\u4ec6 {} \u9884\u52a0\u8f7d\u4f20\u9001\u76ee\u6807\u533a\u5757: {}", (Object)maidId, (Object)targetKey);
        try {
            MinecraftServer server = maid.m_20194_();
            if (server == null) {
                return;
            }
            ChunkLoadingManager.performChunkOperation(maidId, targetKey, true, 100);
        }
        catch (Exception e) {
            Global.LOGGER.error("\u9884\u52a0\u8f7d\u5973\u4ec6 {} \u4f20\u9001\u76ee\u6807\u533a\u5757\u65f6\u53d1\u751f\u9519\u8bef", (Object)maidId, (Object)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer().m_129921_() % 20 == 0) {
            ChunkLoadingManager.processChunkTimers();
        }
    }

    @SubscribeEvent
    public static void onoMaidTick(MaidTickEvent event) {
        EntityMaid maid = event.getMaid();
        if (maid.m_9236_().m_5776_()) {
            return;
        }
        if (maid.f_19797_ % 20 == 0) {
            // empty if block
        }
    }

    private static void processChunkTimers() {
        if (chunkTimers.isEmpty()) {
            return;
        }
        reusableExpiredChunks.clear();
        MinecraftServer server = ChunkLoadingManager.getCurrentServer();
        if (server == null) {
            return;
        }
        for (Map.Entry<ChunkKey, ChunkTimer> entry : chunkTimers.entrySet()) {
            ChunkKey chunkKey = entry.getKey();
            ChunkTimer timer = entry.getValue();
            ServerLevel level = chunkKey.getLevel();
            if (level == null) {
                reusableExpiredChunks.add(chunkKey);
                continue;
            }
            Set<UUID> associatedMaids = timer.getAssociatedMaids();
            Iterator<UUID> iterator = associatedMaids.iterator();
            while (iterator.hasNext()) {
                UUID maidId = iterator.next();
                try {
                    EntityMaid maid;
                    boolean isValid = false;
                    Entity entity = level.m_8791_(maidId);
                    if (entity instanceof EntityMaid && BaubleStateManager.hasBauble(maid = (EntityMaid)entity, MaidSpellItems.ANCHOR_CORE) && maid.m_146902_().equals((Object)chunkKey.chunkPos())) {
                        isValid = true;
                    }
                    if (isValid) continue;
                    iterator.remove();
                }
                catch (Exception e) {
                    iterator.remove();
                    Global.LOGGER.debug("\u83b7\u53d6\u5973\u4ec6\u5b9e\u4f53 {} \u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)maidId, (Object)e.getMessage());
                }
            }
            if (!associatedMaids.isEmpty()) continue;
            timer.update();
            if (!timer.isExpired()) continue;
            reusableExpiredChunks.add(chunkKey);
        }
        for (ChunkKey expiredChunk : reusableExpiredChunks) {
            ChunkLoadingManager.unloadExpiredChunk(expiredChunk);
        }
        if (!reusableExpiredChunks.isEmpty()) {
            Global.LOGGER.debug("\u5378\u8f7d\u4e86 {} \u4e2a\u8fc7\u671f\u533a\u5757", (Object)reusableExpiredChunks.size());
        }
    }

    private static void unloadExpiredChunk(ChunkKey chunkKey) {
        ChunkTimer timer = chunkTimers.remove(chunkKey);
        if (timer == null) {
            return;
        }
        ServerLevel serverLevel = chunkKey.getLevel();
        if (serverLevel == null) {
            Global.LOGGER.warn("\u65e0\u6cd5\u627e\u5230\u7ef4\u5ea6 {} \u6765\u5378\u8f7d\u533a\u5757", (Object)chunkKey.dimension().m_135782_());
            return;
        }
        for (UUID maidId : timer.getAssociatedMaids()) {
            ChunkLoadingManager.performChunkOperation(maidId, chunkKey, false);
        }
        Global.LOGGER.debug("\u5378\u8f7d\u8fc7\u671f\u533a\u5757: {} (\u5173\u8054\u5973\u4ec6: {})", (Object)chunkKey, timer.getAssociatedMaids());
    }

    private static MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    private static boolean performChunkOperation(UUID maidId, ChunkKey info, boolean enable) {
        return ChunkLoadingManager.performChunkOperation(maidId, info, enable, 200);
    }

    private static boolean performChunkOperation(UUID maidId, ChunkKey info, boolean enable, int lifetimeTicks) {
        ServerLevel serverLevel = info.getLevel();
        ChunkPos chunkPos = info.chunkPos();
        if (serverLevel == null) {
            return false;
        }
        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"touhou_little_maid_spell", (UUID)maidId, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)enable, (boolean)true);
        ChunkLoadingData data = ChunkLoadingData.get(serverLevel.m_7654_());
        data.updateMaidPosition(maidId, info, enable);
        if (enable) {
            ChunkTimer timer = chunkTimers.computeIfAbsent(info, k -> new ChunkTimer(info, lifetimeTicks));
            timer.addMaid(maidId);
        }
        return true;
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        maidChunkPositions.clear();
        try {
            ChunkLoadingData.get(server);
            if (!maidChunkPositions.isEmpty()) {
                Global.LOGGER.info("\u670d\u52a1\u5668\u542f\u52a8\u65f6\u53d1\u73b0 {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u914d\u7f6e", (Object)maidChunkPositions.size());
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("\u670d\u52a1\u5668\u542f\u52a8\u65f6\u52a0\u8f7d\u533a\u5757\u52a0\u8f7d\u6570\u636e\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (maidChunkPositions.isEmpty()) {
            return;
        }
        Global.LOGGER.info("\u670d\u52a1\u5668\u542f\u52a8\u5b8c\u6210\uff0c\u5f00\u59cb\u6062\u590d {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u914d\u7f6e...", (Object)maidChunkPositions.size());
        int restoredCount = 0;
        for (Map.Entry<UUID, Set<ChunkKey>> entry : maidChunkPositions.entrySet()) {
            UUID maidId = entry.getKey();
            Set<ChunkKey> chunks = entry.getValue();
            for (ChunkKey info : chunks) {
                if (!ChunkLoadingManager.performChunkOperation(maidId, info, true)) continue;
                ++restoredCount;
            }
        }
        Global.LOGGER.info("\u670d\u52a1\u5668\u542f\u52a8\u65f6\u6210\u529f\u6062\u590d\u4e86 {} \u4e2a\u533a\u5757\u7684\u52a0\u8f7d", (Object)restoredCount);
    }

    public static final class ChunkKey {
        private final ChunkPos chunkPos;
        private final ResourceKey<Level> dimension;

        public ChunkKey(ChunkPos chunkPos, ResourceKey<Level> dimension) {
            this.chunkPos = chunkPos;
            this.dimension = dimension;
        }

        public ChunkKey(ChunkPos chunkPos, ServerLevel level) {
            this(chunkPos, (ResourceKey<Level>)level.m_46472_());
        }

        public ChunkPos chunkPos() {
            return this.chunkPos;
        }

        public ResourceKey<Level> dimension() {
            return this.dimension;
        }

        @Nullable
        public ServerLevel getLevel() {
            MinecraftServer server = ChunkLoadingManager.getCurrentServer();
            if (server == null) {
                return null;
            }
            return server.m_129880_(this.dimension);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChunkKey)) {
                return false;
            }
            ChunkKey other = (ChunkKey)obj;
            return this.chunkPos.equals((Object)other.chunkPos) && this.dimension.equals(other.dimension);
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos, this.dimension);
        }

        public String toString() {
            return String.valueOf(this.chunkPos) + " (" + String.valueOf(this.dimension.m_135782_()) + ")";
        }
    }

    private static class ChunkTimer {
        private int remainingTicks;
        private final Set<UUID> associatedMaids;
        private final ChunkKey chunkKey;

        public ChunkTimer(ChunkKey chunkKey, int initialTicks) {
            this.chunkKey = chunkKey;
            this.remainingTicks = initialTicks;
            this.associatedMaids = ConcurrentHashMap.newKeySet();
        }

        public void addMaid(UUID maidId) {
            this.associatedMaids.add(maidId);
        }

        public Set<UUID> getAssociatedMaids() {
            return new HashSet<UUID>(this.associatedMaids);
        }

        public void update() {
            this.remainingTicks = Math.max(0, this.remainingTicks - 20);
        }

        public boolean isExpired() {
            return this.remainingTicks <= 0;
        }

        public String toString() {
            return String.format("ChunkTimer{%s, ticks=%d, maids=%s}", this.chunkKey, this.remainingTicks, this.associatedMaids);
        }
    }

    public static class ChunkLoadingData
    extends SavedData {
        private static final String DATA_NAME = "maidspell_chunk_loading";

        public ChunkLoadingData() {
        }

        public ChunkLoadingData(CompoundTag tag) {
            ChunkLoadingData.load(tag);
        }

        public static ChunkLoadingData load(CompoundTag tag) {
            ChunkLoadingData data = new ChunkLoadingData();
            CompoundTag maidsTag = tag.m_128469_("maids");
            int loadedCount = 0;
            for (String uuidStr : maidsTag.m_128431_()) {
                try {
                    UUID maidId = UUID.fromString(uuidStr);
                    CompoundTag maidTag = maidsTag.m_128469_(uuidStr);
                    CompoundTag chunksTag = maidTag.m_128469_("chunks");
                    ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
                    for (String chunkIdxStr : chunksTag.m_128431_()) {
                        CompoundTag chunkTag = chunksTag.m_128469_(chunkIdxStr);
                        int chunkX = chunkTag.m_128451_("x");
                        int chunkZ = chunkTag.m_128451_("z");
                        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                        String dimensionStr = chunkTag.m_128461_("dimension");
                        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionStr));
                        ChunkKey chunkKey = new ChunkKey(chunkPos, (ResourceKey<Level>)dimension);
                        chunkTimers.put(chunkKey, new ChunkTimer(chunkKey, 200));
                        chunks.add(chunkKey);
                    }
                    if (chunks.isEmpty()) continue;
                    maidChunkPositions.put(maidId, chunks);
                    ++loadedCount;
                }
                catch (Exception e) {
                    Global.LOGGER.error("\u52a0\u8f7d\u5973\u4ec6 {} \u7684\u533a\u5757\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Object)uuidStr, (Object)e);
                }
            }
            Global.LOGGER.info("\u6210\u529f\u52a0\u8f7d {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e", (Object)loadedCount);
            return data;
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag tag) {
            CompoundTag maidsTag = new CompoundTag();
            for (Map.Entry<UUID, Set<ChunkKey>> entry : maidChunkPositions.entrySet()) {
                UUID maidId = entry.getKey();
                Set<ChunkKey> chunks = entry.getValue();
                if (chunks.isEmpty()) continue;
                CompoundTag maidTag = new CompoundTag();
                CompoundTag chunksTag = new CompoundTag();
                int idx = 0;
                for (ChunkKey chunkKey : chunks) {
                    CompoundTag chunkTag = new CompoundTag();
                    chunkTag.m_128405_("x", chunkKey.chunkPos().f_45578_);
                    chunkTag.m_128405_("z", chunkKey.chunkPos().f_45579_);
                    chunkTag.m_128359_("dimension", chunkKey.dimension().m_135782_().toString());
                    chunksTag.m_128365_(String.valueOf(idx++), (Tag)chunkTag);
                }
                maidTag.m_128365_("chunks", (Tag)chunksTag);
                maidsTag.m_128365_(maidId.toString(), (Tag)maidTag);
            }
            tag.m_128365_("maids", (Tag)maidsTag);
            Global.LOGGER.debug("\u6210\u529f\u4fdd\u5b58 {} \u4e2a\u5973\u4ec6\u7684\u533a\u5757\u52a0\u8f7d\u6570\u636e", (Object)maidChunkPositions.size());
            return tag;
        }

        public void updateMaidPosition(UUID maidId, ChunkKey info, boolean add) {
            if (add) {
                maidChunkPositions.computeIfAbsent(maidId, k -> ConcurrentHashMap.newKeySet()).add(info);
            } else {
                Set<ChunkKey> chunks = maidChunkPositions.get(maidId);
                if (chunks != null) {
                    chunks.remove(info);
                    if (chunks.isEmpty()) {
                        maidChunkPositions.remove(maidId);
                    }
                }
            }
            this.m_77762_();
        }

        public static ChunkLoadingData get(MinecraftServer server) {
            return (ChunkLoadingData)server.m_129783_().m_8895_().m_164861_(ChunkLoadingData::load, ChunkLoadingData::new, DATA_NAME);
        }
    }
}

