/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.holders;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemLaserEntity;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterData;
import dev.xkmc.youkaishomecoming.content.spell.shooter.ShooterEntity;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.LivingCardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCard;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MaidCardHolder
implements LivingCardHolder {
    private final EntityMaid maid;
    private final LivingEntity target;

    public MaidCardHolder(EntityMaid maid, @Nullable LivingEntity target) {
        this.maid = maid;
        this.target = target;
    }

    public LivingEntity self() {
        return this.maid;
    }

    public LivingEntity shooter() {
        return this.maid;
    }

    @Nullable
    public LivingEntity targetEntity() {
        return this.target;
    }

    public float getDamage(YHDanmaku.IDanmakuType type) {
        return type.damage();
    }

    public Vec3 center() {
        return this.maid.m_20182_().m_82520_(0.0, (double)(this.maid.m_20206_() / 2.0f), 0.0);
    }

    public Vec3 forward() {
        Vec3 targetPos = this.target();
        if (targetPos != null) {
            return targetPos.m_82546_(this.center()).m_82541_();
        }
        return this.maid.m_20156_();
    }

    @Nullable
    public Vec3 target() {
        if (this.target == null) {
            return null;
        }
        return this.target.m_20182_().m_82520_(0.0, (double)(this.target.m_20206_() / 2.0f), 0.0);
    }

    @Nullable
    public Vec3 targetVelocity() {
        if (this.target == null) {
            return null;
        }
        return this.target.m_20184_();
    }

    public RandomSource random() {
        return this.maid.m_217043_();
    }

    public ItemDanmakuEntity prepareDanmaku(int life, Vec3 vec, YHDanmaku.Bullet type, DyeColor color) {
        ItemDanmakuEntity danmaku = new ItemDanmakuEntity((EntityType)YHEntities.ITEM_DANMAKU.get(), this.shooter(), this.maid.m_9236_());
        danmaku.m_146884_(this.center());
        danmaku.setItem(type.get(color).asStack());
        danmaku.setup(this.getDamage((YHDanmaku.IDanmakuType)type), life, true, true, vec);
        return danmaku;
    }

    public ItemLaserEntity prepareLaser(int life, Vec3 pos, Vec3 vec, float len, YHDanmaku.Laser type, DyeColor color) {
        ItemLaserEntity laser = new ItemLaserEntity((EntityType)YHEntities.ITEM_LASER.get(), this.shooter(), this.maid.m_9236_());
        laser.setItem(type.get(color).asStack());
        laser.setup(this.getDamage((YHDanmaku.IDanmakuType)type), life, len, true, vec);
        laser.m_146884_(pos);
        laser.setupLength = type.setupLength();
        return laser;
    }

    public ShooterEntity prepareShooter(ShooterData data, SpellCard spell) {
        ShooterEntity shooter = new ShooterEntity((EntityType)YHEntities.SHOOTER.get(), this.maid.m_9236_());
        shooter.setup(this.shooter(), this.targetEntity(), data, spell);
        return shooter;
    }

    public void shoot(Entity danmaku) {
        Level level = this.maid.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_7967_(danmaku);
        }
    }
}

