/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.helpers;

import com.mojang.logging.LogUtils;
import dev.xkmc.youkaishomecoming.content.spell.game.TouhouSpellCards;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCardWrapper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class SpellCardHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, String> ITEM_TO_SPELL_CARD = new HashMap<String, String>();
    private static final List<String> ITEM_LESS_SPELL_CARDS = Arrays.asList("touhou_little_maid:cirno", "touhou_little_maid:sunny_milk", "touhou_little_maid:luna_child", "touhou_little_maid:star_sapphire", "touhou_little_maid:doremy_sweet", "touhou_little_maid:kisin_sagume", "touhou_little_maid:eternity_larva");
    private static final Set<String> CUSTOM_SPELL_ITEMS = new HashSet<String>(Arrays.asList("item.youkaishomecoming.custom_spell_ring", "item.youkaishomecoming.custom_spell_homing"));
    private static final Random RANDOM = new Random();
    private static Map<String, Supplier<SpellCard>> spellCardMap;

    private static Map<String, Supplier<SpellCard>> getSpellCardMap() {
        if (spellCardMap != null) {
            return spellCardMap;
        }
        try {
            Field mapField = TouhouSpellCards.class.getDeclaredField("MAP");
            mapField.setAccessible(true);
            spellCardMap = (Map)mapField.get(null);
            LOGGER.info("Successfully accessed TouhouSpellCards MAP via reflection");
            return spellCardMap;
        }
        catch (Exception e) {
            LOGGER.error("Failed to access TouhouSpellCards MAP: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static SpellCardWrapper createSpellCard(String spellCardId) {
        Map<String, Supplier<SpellCard>> map = SpellCardHelper.getSpellCardMap();
        if (map == null) {
            LOGGER.error("SpellCard MAP is null, cannot create spell card");
            return null;
        }
        Supplier<SpellCard> supplier = map.get(spellCardId);
        if (supplier == null) {
            LOGGER.warn("No spell card found for id: {}", (Object)spellCardId);
            return null;
        }
        try {
            SpellCardWrapper wrapper = new SpellCardWrapper();
            wrapper.modelId = spellCardId;
            wrapper.card = supplier.get();
            return wrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create spell card {}: {}", (Object)spellCardId, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean hasSpellCard(String spellCardId) {
        Map<String, Supplier<SpellCard>> map = SpellCardHelper.getSpellCardMap();
        return map != null && map.containsKey(spellCardId);
    }

    public static String getRandomItemlessSpellCard() {
        if (ITEM_LESS_SPELL_CARDS.isEmpty()) {
            LOGGER.warn("Item-less spell card list is empty!");
            return null;
        }
        int index = RANDOM.nextInt(ITEM_LESS_SPELL_CARDS.size());
        String spellCardId = ITEM_LESS_SPELL_CARDS.get(index);
        LOGGER.debug("Randomly selected spell card: {}", (Object)spellCardId);
        return spellCardId;
    }

    public static String getSpellCardIdFromItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return null;
        }
        Item item = itemStack.m_41720_();
        String itemId = item.m_5524_();
        if (CUSTOM_SPELL_ITEMS.contains(itemId)) {
            LOGGER.info("Custom spell item detected: {}, selecting random spell card", (Object)itemId);
            return SpellCardHelper.getRandomItemlessSpellCard();
        }
        return ITEM_TO_SPELL_CARD.get(itemId);
    }

    public static SpellCardWrapper createSpellCardFromItem(ItemStack itemStack) {
        String spellCardId = SpellCardHelper.getSpellCardIdFromItem(itemStack);
        if (spellCardId == null) {
            return null;
        }
        return SpellCardHelper.createSpellCard(spellCardId);
    }

    public static boolean isSpellCardItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        String itemId = itemStack.m_41720_().m_5524_();
        return CUSTOM_SPELL_ITEMS.contains(itemId) || ITEM_TO_SPELL_CARD.containsKey(itemId);
    }

    static {
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_reimu", "touhou_little_maid:hakurei_reimu");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_sanae", "touhou_little_maid:kochiya_sanae");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_marisa", "touhou_little_maid:kirisame_marisa");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_mystia", "touhou_little_maid:mystia_lorelei");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_remilia", "touhou_little_maid:remilia_scarlet");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_koishi", "touhou_little_maid:komeiji_koishi");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_yukari_butterfly", "touhou_little_maid:yukari_yakumo");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_yukari_laser", "touhou_little_maid:yukari_yakumo");
        ITEM_TO_SPELL_CARD.put("item.youkaishomecoming.spell_clownpiece", "touhou_little_maid:clownpiece");
        spellCardMap = null;
    }
}

