/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.yimeng261.maidspell.api.IMaidSpellData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MaidSlashBladeData
extends IMaidSpellData {
    private static final Map<UUID, MaidSlashBladeData> DATA_MAP = new ConcurrentHashMap<UUID, MaidSlashBladeData>();
    private long saExecutionStartTime = 0L;
    private ResourceLocation lastComboState = null;
    private int targetUseTime = 0;
    private int cooldown = 0;
    private int nonDashSkillCount = 0;

    private MaidSlashBladeData(UUID maidUUID) {
    }

    public static MaidSlashBladeData getOrCreate(UUID maidUUID) {
        return DATA_MAP.computeIfAbsent(maidUUID, MaidSlashBladeData::new);
    }

    public static void remove(UUID maidUUID) {
        DATA_MAP.remove(maidUUID);
    }

    public void setSAExecutionStartTime(long time) {
        this.saExecutionStartTime = time;
    }

    public long getSAExecutionStartTime() {
        return this.saExecutionStartTime;
    }

    public int getTargetUseTime() {
        return this.targetUseTime;
    }

    public void setTargetUseTime(int time) {
        this.targetUseTime = time;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int time) {
        this.cooldown = time;
    }

    public Boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    public ResourceLocation getLastComboState() {
        return this.lastComboState;
    }

    public void setLastComboState(ResourceLocation lastComboState) {
        this.lastComboState = lastComboState;
    }

    public int getNonDashSkillCount() {
        return this.nonDashSkillCount;
    }

    public void incrementNonDashSkillCount() {
        ++this.nonDashSkillCount;
    }

    public void resetNonDashSkillCount() {
        this.nonDashSkillCount = 0;
    }

    @Override
    public void updateCooldowns() {
        this.cooldown -= 20;
    }

    @Override
    public void removeSpellBook(ItemStack spellBook) {
        for (ItemStack oldSpellBook : this.spellBooks) {
            if (!ItemStack.m_41656_((ItemStack)oldSpellBook, (ItemStack)spellBook)) continue;
            this.spellBookKinds.remove(spellBook.m_41720_().getClass());
            this.spellBooks.remove(oldSpellBook);
            return;
        }
    }

    public void reset() {
        this.target = null;
        this.isCasting = false;
        this.saExecutionStartTime = 0L;
        this.targetUseTime = 0;
        this.lastComboState = null;
    }
}

