/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.yimeng261.maidspell.api.IMaidSpellData;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import vazkii.psi.api.spell.Spell;

public class MaidPsiSpellData
extends IMaidSpellData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, MaidPsiSpellData> MAID_DATA = new ConcurrentHashMap<UUID, MaidPsiSpellData>();
    private Spell currentSpell;
    private int castingTicks = 0;

    private MaidPsiSpellData(UUID maidUUID) {
    }

    public static MaidPsiSpellData getOrCreate(UUID maidUUID) {
        return MAID_DATA.computeIfAbsent(maidUUID, MaidPsiSpellData::new);
    }

    public static void remove(UUID maidUUID) {
        MAID_DATA.remove(maidUUID);
    }

    public Spell getCurrentSpell() {
        return this.currentSpell;
    }

    public void setCurrentSpell(Spell spell) {
        this.currentSpell = spell;
        if (spell != null) {
            this.setCurrentSpellId(spell.name);
        }
    }

    public int getCastingTicks() {
        return this.castingTicks;
    }

    public void setCastingTicks(int ticks) {
        this.castingTicks = ticks;
    }

    @Override
    public void resetCastingState() {
        this.setCasting(false);
        this.currentSpell = null;
        this.castingTicks = 0;
    }
}

