/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.IMaidSpellData;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.LivingEntity;

public class MaidIronsSpellData
extends IMaidSpellData {
    private static final Map<UUID, MaidIronsSpellData> MAID_DATA_MAP = new ConcurrentHashMap<UUID, MaidIronsSpellData>();
    private LivingEntity origin_target = null;
    private SpellData currentCastingSpell = null;
    private final MagicData magicData = new MagicData(true);
    private CastSource cachedCastSource = null;

    private MaidIronsSpellData() {
    }

    public static MaidIronsSpellData getOrCreate(UUID maidUuid) {
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidIronsSpellData());
    }

    public static MaidIronsSpellData getOrCreate(EntityMaid maidEntity) {
        UUID maidUuid = maidEntity.m_20148_();
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidIronsSpellData());
    }

    public static MaidIronsSpellData get(UUID maidUuid) {
        return MAID_DATA_MAP.get(maidUuid);
    }

    public static void remove(UUID maidUuid) {
        MAID_DATA_MAP.remove(maidUuid);
    }

    public void switchTargetToOwner(EntityMaid maid) {
        this.origin_target = this.getTarget();
        this.setTarget(maid.m_269323_());
    }

    public void switchTargetToOrigin(EntityMaid maid) {
        this.setTarget(this.origin_target);
    }

    public LivingEntity getOriginTarget() {
        return this.origin_target;
    }

    public void setOriginTarget(LivingEntity originTarget) {
        this.origin_target = originTarget;
    }

    public SpellData getCurrentCastingSpell() {
        return this.currentCastingSpell;
    }

    public void setCurrentCastingSpell(SpellData spell) {
        this.currentCastingSpell = spell;
        if (spell != null && spell.getSpell() != null) {
            this.setCurrentSpellId(spell.getSpell().getSpellId());
        }
    }

    public CastSource getCachedCastSource() {
        return this.cachedCastSource;
    }

    public void setCachedCastSource(CastSource castSource) {
        this.cachedCastSource = castSource;
    }

    public void clearCachedCastSource() {
        this.cachedCastSource = null;
    }

    public MagicData getMagicData() {
        return this.magicData;
    }

    @Override
    public void resetCastingState() {
        this.setCasting(false);
        this.currentCastingSpell = null;
        this.clearCachedCastSource();
        this.magicData.resetCastingState();
    }
}

