/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import com.Polarice3.Goety.api.magic.ISpell;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.IMaidSpellData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;

public class MaidGoetySpellData
extends IMaidSpellData {
    private static final Map<UUID, MaidGoetySpellData> MAID_DATA_MAP = new ConcurrentHashMap<UUID, MaidGoetySpellData>();
    private int castingTime = 0;
    private int maxCastingTime = 0;
    private ISpell currentSpell = null;
    private boolean spellUsed = false;
    private ItemStack currentFocus = null;
    private int coolCounter = 0;
    private int shotsFired = 0;

    private MaidGoetySpellData() {
    }

    public static MaidGoetySpellData getOrCreate(UUID maidUuid) {
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidGoetySpellData());
    }

    public static MaidGoetySpellData getOrCreate(EntityMaid maidEntity) {
        UUID maidUuid = maidEntity.m_20148_();
        return MAID_DATA_MAP.computeIfAbsent(maidUuid, k -> new MaidGoetySpellData());
    }

    public static MaidGoetySpellData get(UUID maidUuid) {
        return MAID_DATA_MAP.get(maidUuid);
    }

    public boolean spellUsed() {
        return this.spellUsed;
    }

    public void setSpellUsed(boolean spellUsed) {
        this.spellUsed = spellUsed;
    }

    public static void remove(UUID maidUuid) {
        MAID_DATA_MAP.remove(maidUuid);
    }

    public int getCastingTime() {
        return this.castingTime;
    }

    public void setCastingTime(int castingTime) {
        this.castingTime = castingTime;
    }

    public void incrementCastingTime() {
        ++this.castingTime;
    }

    public int getMaxCastingTime() {
        return this.maxCastingTime;
    }

    public void setMaxCastingTime(int maxCastingTime) {
        this.maxCastingTime = maxCastingTime;
    }

    public ISpell getCurrentSpell() {
        return this.currentSpell;
    }

    public void setCurrentSpell(ISpell currentSpell) {
        this.currentSpell = currentSpell;
        if (currentSpell != null) {
            this.setCurrentSpellId(currentSpell.getClass().getSimpleName());
        }
    }

    public int getCoolCounter() {
        return this.coolCounter;
    }

    public void setCoolCounter(int coolCounter) {
        this.coolCounter = coolCounter;
    }

    public void incrementCoolCounter() {
        ++this.coolCounter;
    }

    public int getShotsFired() {
        return this.shotsFired;
    }

    public void setShotsFired(int shotsFired) {
        this.shotsFired = shotsFired;
    }

    public void incrementShotsFired() {
        ++this.shotsFired;
    }

    @Override
    public void resetCastingState() {
        this.setCasting(false);
        this.castingTime = 0;
        this.maxCastingTime = 0;
        this.currentSpell = null;
        this.coolCounter = 0;
        this.shotsFired = 0;
        this.spellUsed = false;
    }

    public void resetChargingCounters() {
        this.coolCounter = 0;
        this.shotsFired = 0;
    }

    public void initiateCastingState(ISpell spell, int duration) {
        this.setCurrentSpell(spell);
        this.castingTime = 0;
        this.maxCastingTime = duration;
        this.setCasting(true);
    }

    public ItemStack getCurrentFocus() {
        return this.currentFocus;
    }

    public void setCurrentFocus(ItemStack currentFocus) {
        this.currentFocus = currentFocus;
    }
}

