/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.network.message;

import com.github.yimeng261.maidspell.network.message.SpellSyncClientHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SpellSyncMessage {
    private final UUID maidUUID;
    private final Map<String, String> spellMap;

    public SpellSyncMessage(UUID maidUUID, Map<String, String> spellMap) {
        this.maidUUID = maidUUID;
        this.spellMap = spellMap != null ? spellMap : new HashMap();
    }

    public static void encode(SpellSyncMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.maidUUID);
        buf.writeInt(message.spellMap.size());
        for (Map.Entry<String, String> entry : message.spellMap.entrySet()) {
            buf.m_130070_(entry.getKey());
            buf.m_130070_(entry.getValue());
        }
    }

    public static SpellSyncMessage decode(FriendlyByteBuf buf) {
        UUID maidUUID = buf.m_130259_();
        int spellCount = buf.readInt();
        HashMap<String, String> spellMap = new HashMap<String, String>();
        for (int i = 0; i < spellCount; ++i) {
            String modId = buf.m_130277_();
            String spellName = buf.m_130277_();
            spellMap.put(modId, spellName);
        }
        return new SpellSyncMessage(maidUUID, spellMap);
    }

    public static void handle(SpellSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer()) {
                return;
            }
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SpellSyncMessage.handleClientSide(message));
        });
        context.setPacketHandled(true);
    }

    private static void handleClientSide(SpellSyncMessage message) {
        SpellSyncClientHandler.handleSpellSync(message.maidUUID, message.spellMap);
    }

    public UUID getMaidUUID() {
        return this.maidUUID;
    }

    public Map<String, String> getSpellMap() {
        return this.spellMap;
    }
}

