/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFeedOwner;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.yimeng261.maidspell.Config;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.item.bauble.fragrantIngenuity.FragrantIngenuityBauble;
import com.mojang.logging.LogUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TaskFeedOwner.class}, remap=false)
public class TaskFeedOwnerMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"feed(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, remap=false)
    private void onFeedOwner(ItemStack stack, Player owner, CallbackInfoReturnable<ItemStack> cir) {
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        EntityMaid feedingMaid = null;
        for (EntityMaid maid : serverLevel.m_45976_(EntityMaid.class, owner.m_20191_().m_82400_(7.0))) {
            if (maid.m_269323_() != owner || !ItemsUtil.hasBaubleItemInMaid((EntityMaid)maid, (Item)((Item)MaidSpellItems.FRAGRANT_INGENUITY.get()))) continue;
            feedingMaid = maid;
            break;
        }
        if (feedingMaid == null) {
            return;
        }
        if (FragrantIngenuityBauble.POSITIVE_EFFECTS.isEmpty()) {
            LOGGER.warn("[FragrantIngenuity] No positive effects available!");
            return;
        }
        MobEffect randomEffect = FragrantIngenuityBauble.POSITIVE_EFFECTS.get(owner.m_217043_().m_188503_(FragrantIngenuityBauble.POSITIVE_EFFECTS.size()));
        int duration = Config.fragrantIngenuityBuffDuration;
        owner.m_7292_(new MobEffectInstance(randomEffect, duration, 0));
    }
}

