/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public class MobMixin {
    @Inject(method={"convertTo(Lnet/minecraft/world/entity/EntityType;Z)Lnet/minecraft/world/entity/Mob;"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends Mob> void preventMaidConversion(EntityType<T> entityType, boolean bl, CallbackInfoReturnable<T> cir) {
        MobMixin mobMixin = this;
        if (mobMixin instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)mobMixin;
            if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                Global.LOGGER.debug("Maid {} does not have anchor_core, allowing conversion", (Object)maid.m_20148_());
                return;
            }
            Global.LOGGER.debug("\u963b\u6b62\u5973\u4ec6 {} \u88ab\u8f6c\u6362\u6210 {} (anchor_core protection)", (Object)maid.m_20148_(), (Object)entityType.m_20675_());
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"dropCustomDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    protected void preventMaidLootDrop(DamageSource damageSource, int looting, boolean recentlyHit, CallbackInfo ci) {
        MobMixin mobMixin = this;
        if (mobMixin instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)mobMixin;
            if (!BaubleStateManager.hasBauble(maid, MaidSpellItems.ANCHOR_CORE)) {
                Global.LOGGER.debug("Maid {} does not have anchor_core, allowing loot drop", (Object)maid.m_20148_());
                return;
            }
            if (maid.m_21223_() > 0.0f) {
                Global.LOGGER.debug("\u963b\u6b62\u8840\u91cf\u5927\u4e8e0\u7684\u5973\u4ec6 {} \u6389\u843d\u6218\u5229\u54c1 (anchor_core protection)", (Object)maid.m_20148_());
                ci.cancel();
            }
        }
    }
}

