/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.github.yimeng261.maidspell.spell.manager.BaubleStateManager;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractMaidContainer.class}, remap=false)
public class AbstractMaidContainerMixin {
    @Final
    @Shadow
    protected EntityMaid maid;

    @Inject(method={"stillValid"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void stillValid(Player playerIn, CallbackInfoReturnable<Boolean> cir) {
        if (this.maid.getMaidBauble().containsItem((Item)MaidSpellItems.ENDER_POCKET.get())) {
            boolean isValid = this.maid.m_21830_((LivingEntity)playerIn) && !this.maid.m_5803_() && this.maid.m_6084_();
            cir.setReturnValue((Object)isValid);
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntity(I)Lnet/minecraft/world/entity/Entity;", remap=true), remap=true)
    @Nullable
    private Entity redirectGetEntity(Level level, int entityId) {
        Entity entity = level.m_6815_(entityId);
        if (entity instanceof EntityMaid) {
            return entity;
        }
        try {
            for (EntityMaid maid : Global.maidList) {
                if (maid.m_19879_() != entityId || !BaubleStateManager.hasBauble(maid, MaidSpellItems.ENDER_POCKET)) continue;
                Global.LOGGER.debug("\u4eceGlobal\u7f13\u5b58\u4e2d\u627e\u5230\u8fdc\u8ddd\u79bb\u5973\u4ec6: {} (ID: {})", (Object)maid.m_7755_().getString(), (Object)entityId);
                entity = maid;
                break;
            }
        }
        catch (Exception e) {
            Global.LOGGER.error("\u4eceGlobal\u7f13\u5b58\u4e2d\u67e5\u627e\u5973\u4ec6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return entity;
    }
}

