/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchCacheManager;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.SearchConfig;
import com.github.yimeng261.maidspell.item.common.WindSeekingBell.StripedLock;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;

public class StructureSearchEngine {
    private static final ResourceLocation HIDDEN_RETREAT_LOCATION = new ResourceLocation("touhou_little_maid_spell", "hidden_retreat");
    private static final ResourceKey<Structure> HIDDEN_RETREAT_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)HIDDEN_RETREAT_LOCATION);
    private static volatile HolderSet<Structure> cachedStructureSet = null;
    private static final Object STRUCTURE_SET_LOCK = new Object();
    private static final StripedLock STRUCTURE_CHECK_LOCK = new StripedLock(64);
    private static final ThreadPoolExecutor SEARCH_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(SearchConfig.getRecommendedThreadPoolSize(), r -> {
        Thread t = new Thread(r, "WindSeekingBell-Search-" + System.currentTimeMillis());
        t.setDaemon(true);
        t.setPriority(4);
        return t;
    });
    private final SearchCacheManager cacheManager;

    public StructureSearchEngine(SearchCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CompletableFuture<BlockPos> searchAsync(ServerLevel level, BlockPos playerPos) {
        SearchCacheManager.CacheCheckResult cacheResult = this.cacheManager.checkCache(level);
        if (cacheResult.hasCache) {
            if (cacheResult.isNegativeCache) {
                Global.LOGGER.debug("Negative cache hit for dimension: {}, skipping search", (Object)level.m_46472_().m_135782_());
                return CompletableFuture.completedFuture(null);
            }
            Global.LOGGER.debug("Structure found in cache for dimension: {}", (Object)level.m_46472_().m_135782_());
            return CompletableFuture.completedFuture(cacheResult.structurePos);
        }
        String searchKey = this.cacheManager.generateDimensionKey(level);
        CompletableFuture<BlockPos> existingSearch = this.cacheManager.getOngoingSearch(searchKey);
        if (existingSearch != null) {
            Global.LOGGER.debug("Reusing ongoing search for dimension: {}", (Object)level.m_46472_().m_135782_());
            return existingSearch;
        }
        Global.LOGGER.info("Starting new structure search for dimension: {}", (Object)level.m_46472_().m_135782_());
        CompletionStage searchFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.searchParallel(level, playerPos);
            }
            catch (Exception e) {
                Global.LOGGER.error("Structure search failed for dimension: {}", (Object)level.m_46472_().m_135782_(), (Object)e);
                return null;
            }
        }, SEARCH_EXECUTOR).whenComplete((result, throwable) -> {
            this.cacheManager.removeSearch(searchKey);
            if (result != null) {
                Global.LOGGER.info("Structure search completed successfully for dimension: {}, found at: {}", (Object)level.m_46472_().m_135782_(), result);
            } else {
                Global.LOGGER.warn("Structure search completed but no structure found in dimension: {}", (Object)level.m_46472_().m_135782_());
            }
        });
        this.cacheManager.registerSearch(searchKey, (CompletableFuture<BlockPos>)searchFuture);
        return searchFuture;
    }

    private BlockPos searchParallel(ServerLevel level, BlockPos playerPos) {
        SearchCacheManager.CacheCheckResult cacheResult = this.cacheManager.checkCache(level);
        if (cacheResult.hasCache) {
            return cacheResult.structurePos;
        }
        ChunkPos playerChunk = new ChunkPos(playerPos);
        BlockPos result = this.parallelSquareSearch(level, playerChunk);
        this.cacheManager.updateCache(level, result);
        return result;
    }

    private BlockPos parallelSquareSearch(ServerLevel level, ChunkPos centerChunk) {
        int availableThreads = SearchConfig.getRecommendedThreadPoolSize();
        Global.LOGGER.debug("Starting parallel search with {} threads, radius: {}", (Object)availableThreads, (Object)64000);
        int maxSectorLayer = 64;
        for (int sectorLayer = 0; sectorLayer <= maxSectorLayer; ++sectorLayer) {
            BlockPos result = this.searchSectorLayerParallel(level, centerChunk, sectorLayer);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private BlockPos searchSectorLayerParallel(ServerLevel level, ChunkPos centerChunk, int sectorLayer) {
        if (sectorLayer == 0) {
            return this.searchSectorComplete(level, centerChunk, 0, 0);
        }
        List<int[]> sectorCoords = this.generateSectorCoordinates(sectorLayer);
        ArrayList<CompletableFuture<BlockPos>> sectorTasks = new ArrayList<CompletableFuture<BlockPos>>();
        AtomicBoolean layerComplete = new AtomicBoolean(false);
        for (int[] coords : sectorCoords) {
            int sectorX = coords[0];
            int sectorZ = coords[1];
            CompletableFuture<BlockPos> completableFuture = CompletableFuture.supplyAsync(() -> this.searchSectorWithTermination(level, centerChunk, sectorX, sectorZ, layerComplete), SEARCH_EXECUTOR);
            sectorTasks.add(completableFuture);
        }
        try {
            BlockPos result = null;
            while (!sectorTasks.isEmpty() && result == null) {
                CompletableFuture<Object> anyCompleted = CompletableFuture.anyOf(sectorTasks.toArray(new CompletableFuture[0]));
                try {
                    anyCompleted.get(120L, TimeUnit.SECONDS);
                }
                catch (Exception sectorX) {
                    // empty catch block
                }
                ArrayList<CompletableFuture> remainingTasks = new ArrayList<CompletableFuture>();
                for (CompletableFuture completableFuture : sectorTasks) {
                    if (completableFuture.isDone()) {
                        try {
                            BlockPos taskResult = (BlockPos)completableFuture.get();
                            if (taskResult == null || result != null) continue;
                            result = taskResult;
                            layerComplete.set(true);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    remainingTasks.add(completableFuture);
                }
                sectorTasks = remainingTasks;
                if (result == null) continue;
                for (CompletableFuture completableFuture : sectorTasks) {
                    completableFuture.cancel(true);
                }
            }
            return result;
        }
        catch (Exception e) {
            layerComplete.set(true);
            sectorTasks.forEach(task -> task.cancel(true));
            return null;
        }
    }

    private List<int[]> generateSectorCoordinates(int layer) {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        if (layer == 0) {
            coords.add(new int[]{0, 0});
            return coords;
        }
        int x = -layer;
        while (x <= layer) {
            coords.add(new int[]{x++, layer});
        }
        int z = layer - 1;
        while (z >= -layer) {
            coords.add(new int[]{layer, z--});
        }
        x = layer - 1;
        while (x >= -layer) {
            coords.add(new int[]{x--, -layer});
        }
        z = -layer + 1;
        while (z <= layer - 1) {
            coords.add(new int[]{-layer, z++});
        }
        return coords;
    }

    private BlockPos searchSectorWithTermination(ServerLevel level, ChunkPos centerChunk, int sectorX, int sectorZ, AtomicBoolean layerComplete) {
        if (layerComplete.get()) {
            return null;
        }
        return this.searchSectorComplete(level, centerChunk, sectorX, sectorZ);
    }

    private BlockPos searchSectorComplete(ServerLevel level, ChunkPos centerChunk, int sectorX, int sectorZ) {
        int sectorStartX = centerChunk.f_45578_ + sectorX * 1000 - 500;
        int sectorEndX = sectorStartX + 1000 - 1;
        int sectorStartZ = centerChunk.f_45579_ + sectorZ * 1000 - 500;
        int sectorEndZ = sectorStartZ + 1000 - 1;
        sectorStartX = Math.max(sectorStartX, centerChunk.f_45578_ - 64000);
        sectorEndX = Math.min(sectorEndX, centerChunk.f_45578_ + 64000);
        sectorStartZ = Math.max(sectorStartZ, centerChunk.f_45579_ - 64000);
        sectorEndZ = Math.min(sectorEndZ, centerChunk.f_45579_ + 64000);
        int sectorWidth = sectorEndX - sectorStartX + 1;
        int sectorHeight = sectorEndZ - sectorStartZ + 1;
        BitSet sectorChecked = new BitSet(sectorWidth * sectorHeight);
        ChunkPos sectorCenter = new ChunkPos((sectorStartX + sectorEndX) / 2, (sectorStartZ + sectorEndZ) / 2);
        int sectorRadius = Math.max(sectorWidth, sectorHeight) / 2;
        for (int layer = 0; layer <= sectorRadius; layer += 4) {
            BlockPos result = this.searchSectorLayer(level, sectorCenter, layer, sectorStartX, sectorEndX, sectorStartZ, sectorEndZ, sectorChecked);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private BlockPos searchSectorLayer(ServerLevel level, ChunkPos sectorCenter, int layer, int minX, int maxX, int minZ, int maxZ, BitSet sectorChecked) {
        int z;
        BlockPos result;
        ChunkPos candidate;
        int x;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (layer == 0) {
            if (this.isInSectorBounds(sectorCenter, minX, maxX, minZ, maxZ) && this.isSectorChunkUnchecked(sectorCenter, minX, minZ, sectorChecked, maxX - minX + 1)) {
                this.setSectorChunkChecked(sectorCenter, minX, minZ, sectorChecked, maxX - minX + 1);
                return this.checkPotentialCenter(level, sectorCenter);
            }
            return null;
        }
        for (x = -layer; x <= layer; x += 4) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ + x, sectorCenter.f_45579_ + layer);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (z = layer - 4; z >= -layer; z -= 4) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ + layer, sectorCenter.f_45579_ + z);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (x = layer - 4; x >= -layer; x -= 4) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ + x, sectorCenter.f_45579_ - layer);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        for (z = -layer + 4; z <= layer - 4; z += 4) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            candidate = new ChunkPos(sectorCenter.f_45578_ - layer, sectorCenter.f_45579_ + z);
            if (!this.isInSectorBounds(candidate, minX, maxX, minZ, maxZ) || !this.isSectorChunkUnchecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1)) continue;
            this.setSectorChunkChecked(candidate, minX, minZ, sectorChecked, maxX - minX + 1);
            result = this.checkPotentialCenter(level, candidate);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isInSectorBounds(ChunkPos pos, int minX, int maxX, int minZ, int maxZ) {
        return pos.f_45578_ >= minX && pos.f_45578_ <= maxX && pos.f_45579_ >= minZ && pos.f_45579_ <= maxZ;
    }

    private boolean isSectorChunkUnchecked(ChunkPos chunk, int sectorMinX, int sectorMinZ, BitSet sectorChecked, int sectorWidth) {
        int x = chunk.f_45578_ - sectorMinX;
        int z = chunk.f_45579_ - sectorMinZ;
        if (x < 0 || z < 0 || x >= sectorWidth) {
            return false;
        }
        int index = z * sectorWidth + x;
        return index < 0 || index >= sectorChecked.size() || !sectorChecked.get(index);
    }

    private void setSectorChunkChecked(ChunkPos chunk, int sectorMinX, int sectorMinZ, BitSet sectorChecked, int sectorWidth) {
        int x = chunk.f_45578_ - sectorMinX;
        int z = chunk.f_45579_ - sectorMinZ;
        if (x < 0 || z < 0 || x >= sectorWidth) {
            return;
        }
        int index = z * sectorWidth + x;
        if (index >= 0 && index < sectorChecked.size()) {
            sectorChecked.set(index);
        }
    }

    private BlockPos checkPotentialCenter(ServerLevel level, ChunkPos centerChunk) {
        return this.verifyStructureExists(level, centerChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockPos verifyStructureExists(ServerLevel level, ChunkPos chunk) {
        try {
            HolderSet<Structure> structureSet = StructureSearchEngine.getOrInitStructureSet(level);
            if (structureSet == null) {
                return null;
            }
            BlockPos chunkCenter = new BlockPos(chunk.m_45604_() + 8, 64, chunk.m_45605_() + 8);
            return STRUCTURE_CHECK_LOCK.executeWithLock(level, () -> {
                Pair result = level.m_7726_().m_8481_().m_223037_(level, structureSet, chunkCenter, 1, false);
                return result != null ? (BlockPos)result.getFirst() : null;
            });
        }
        catch (Exception e) {
            Object object = STRUCTURE_SET_LOCK;
            synchronized (object) {
                cachedStructureSet = null;
            }
            Global.LOGGER.debug("Structure verification failed, cache cleared", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HolderSet<Structure> getOrInitStructureSet(ServerLevel level) {
        if (cachedStructureSet == null) {
            Object object = STRUCTURE_SET_LOCK;
            synchronized (object) {
                if (cachedStructureSet == null) {
                    try {
                        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
                        Holder.Reference structureHolder = structureRegistry.m_246971_(HIDDEN_RETREAT_KEY);
                        cachedStructureSet = HolderSet.m_205809_((Holder[])new Holder[]{structureHolder});
                        Global.LOGGER.debug("Initialized structure set for hidden_retreat");
                    }
                    catch (Exception e) {
                        Global.LOGGER.error("Failed to initialize hidden_retreat structure set", (Throwable)e);
                        return null;
                    }
                }
            }
        }
        return cachedStructureSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Object object = STRUCTURE_SET_LOCK;
        synchronized (object) {
            cachedStructureSet = null;
        }
    }
}

