/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.common.WindSeekingBell;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class SearchCacheManager {
    private final Map<String, CacheEntry> structureCache = new ConcurrentHashMap<String, CacheEntry>();
    private final ConcurrentMap<String, CompletableFuture<BlockPos>> ongoingSearches = new ConcurrentHashMap<String, CompletableFuture<BlockPos>>();
    private static final long NEGATIVE_CACHE_TTL_MS = 300000L;

    public CacheCheckResult checkCache(ServerLevel serverLevel) {
        String dimensionKey = serverLevel.m_46472_().m_135782_().toString();
        CacheEntry entry = this.structureCache.get(dimensionKey);
        if (entry != null) {
            if (entry.isNegativeCacheExpired()) {
                this.structureCache.remove(dimensionKey);
                return CacheCheckResult.noCache();
            }
            if (!entry.isNegativeCache()) {
                return CacheCheckResult.withResult(entry.position);
            }
            return CacheCheckResult.withNegativeCache();
        }
        return CacheCheckResult.noCache();
    }

    public void updateCache(ServerLevel serverLevel, BlockPos result) {
        String dimensionKey = serverLevel.m_46472_().m_135782_().toString();
        this.structureCache.put(dimensionKey, new CacheEntry(result));
    }

    public String generateDimensionKey(ServerLevel serverLevel) {
        return serverLevel.m_46472_().m_135782_().toString();
    }

    public CompletableFuture<BlockPos> getOngoingSearch(String searchKey) {
        return (CompletableFuture)this.ongoingSearches.get(searchKey);
    }

    public void registerSearch(String searchKey, CompletableFuture<BlockPos> searchFuture) {
        this.ongoingSearches.put(searchKey, searchFuture);
    }

    public void removeSearch(String searchKey) {
        this.ongoingSearches.remove(searchKey);
    }

    public void clearAll() {
        this.structureCache.clear();
        this.ongoingSearches.clear();
    }

    private static class CacheEntry {
        final BlockPos position;
        final long timestamp;

        CacheEntry(BlockPos position) {
            this.position = position;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isNegativeCache() {
            return this.position == null;
        }

        boolean isNegativeCacheExpired() {
            return this.isNegativeCache() && System.currentTimeMillis() - this.timestamp > 300000L;
        }
    }

    public static class CacheCheckResult {
        public final boolean hasCache;
        public final boolean isNegativeCache;
        public final BlockPos structurePos;

        private CacheCheckResult(boolean hasCache, boolean isNegativeCache, BlockPos pos) {
            this.hasCache = hasCache;
            this.isNegativeCache = isNegativeCache;
            this.structurePos = pos;
        }

        public static CacheCheckResult noCache() {
            return new CacheCheckResult(false, false, null);
        }

        public static CacheCheckResult withResult(BlockPos pos) {
            return new CacheCheckResult(true, false, pos);
        }

        public static CacheCheckResult withNegativeCache() {
            return new CacheCheckResult(true, true, null);
        }
    }
}

