/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.fragrantIngenuity;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAfterEatEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.yimeng261.maidspell.Config;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class FragrantIngenuityBauble
implements IMaidBauble {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final List<MobEffect> POSITIVE_EFFECTS = new ArrayList<MobEffect>();

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        POSITIVE_EFFECTS.clear();
        BuiltInRegistries.f_256974_.m_6579_().forEach(entry -> {
            if (((MobEffect)entry.getValue()).m_19486_()) {
                POSITIVE_EFFECTS.add((MobEffect)entry.getValue());
            }
        });
    }

    public FragrantIngenuityBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void afterMaidEat(MaidAfterEatEvent event) {
        EntityMaid maid = event.getMaid();
        if (ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)this) >= 0) {
            maid.getFavorabilityManager().add(Config.fragrantIngenuityFavorabilityGain);
            LOGGER.debug("[FragrantIngenuity] Maid {} gained {} favorability from eating", (Object)maid.m_7755_().getString(), (Object)Config.fragrantIngenuityFavorabilityGain);
        }
    }
}

